"""
Visualise results from various methods
"""

from __future__ import division, print_function, unicode_literals, absolute_import
import pandas as pd


def algorithm_times():

    """
    Print out the algorithm times for each of the steps.

    @return:
    """

    # Load the dataframes
    df_run1 = pd.read_pickle("data/t1.pkl")
    df_run2 = pd.read_pickle("data/t2.pkl")
    df_run3 = pd.read_pickle("data/t3.pkl")
    df_run7 = pd.read_pickle("data/t4.pkl")

    # Print the mean training and testing time for parts
    print("Preprocessing and supervoxel extraction")
    print("Time: %.2f +/- %.2f" % (df_run1["time"].mean(), df_run1["time"].std()))

    print("Feature extraction")
    print("Time: %.2f +/- %.2f" % (df_run2["time(s)"].mean(), df_run2["time(s)"].std()))

    print("Supervoxel classification")
    print("Time: %.2f +/- %.2f" % (df_run3["time(s)"].mean(), df_run3["time(s)"].std()))

    print("Pieces-of-parts")
    print("Training (s): %.2f +/- %.2f and Testing (s): %.2f +/- %.2f " %
          (df_run7['time_training'].mean(),
           df_run7['time_training'].std(),
           df_run7['time_testing'].mean(),
           df_run7['time_testing'].std()))

    print("Training features are computed. So detection of an unseen case is:")

    tot = (df_run1['time'] + df_run2["time(s)"] + df_run3["time(s)"] + df_run3["time(s)"] + df_run7["time_training"]
           + df_run7["time_testing"])
    print("Time: %.2f +/- %.2f (s)" % (tot.mean(), tot.std()))
    print("Time: %.2f +/- %.2f (min)" % (tot.mean()/60, tot.std()/60))


if __name__ == "__main__":

    # Table 2
    algorithm_times()

