# Notes

The common orthography for Nias ([nias1242](https://glottolog.org/resource/languoid/id/nias1242)) and Toba-Batak ([bata1289](https://glottolog.org/resource/languoid/id/bata1289)) is adapted from the orthography set up for the Enggano ([engg1245](https://glottolog.org/resource/languoid/id/engg1245)) forms as laid out in [this Excel spreadsheet](https://enggano.ling-phil.ox.ac.uk/static/Enggano-transcriptions.xlsx) (from our Enggano [webpage](https://enggano.ling-phil.ox.ac.uk/static/previous.html)), which is transformed into a long-table format [here](https://docs.google.com/spreadsheets/d/14dqSBmov1j5mlIhpbKp53BIh8iNVvFgJjWNi8ZcOgo8/edit?usp=sharing) using [this code](https://github.com/engganolang/enolex/blob/main/codes/r-code_02-orthography.R). The orthography for Enggano is used largely due to the orthography for Nias and Toba-Batak list comes from the same author (i.e., Modigliani).

In the orthography file for each language, there may be empty cells under the `originals` column. This means that the language does not have the corresponding form (with reference to the Italian gloss). The column `..._COMMON` is the non-tokenised (i.e., non-white-spaced) version of the `..._TRANSLITERATED` column. Meanwhile, the `..._TOKENISED` is the tokenised/white-spaced version of the `originals` that has not been transliterated into the common orthography profile for Modigliani (1894).