function pseudocolor_plot(fig)
    % function pseudocolor_plot(fig)
    % fig is figure number supplied as a character string '2', 'S3' etc.
    % pseudocolor_plot('2');  % plots Fig 2 of main text
    % pseudocolor_plot('S7A'); % plots Fig S7, panel A, of SI



    fig=upper(strtrim(fig)); % eliminate white spaces from start&end and convert to uppercase

    switch fig

        case {'2'}

           path = "main_text_data/fig_2/simulation";
           
        case {'3A'}
            
           path = "main_text_data/fig_3/B_7";
           
        case {'3B'}
            
           path = "main_text_data/fig_3/B_8";
           
        case {'3C'}
            
           path = "main_text_data/fig_3/B_9";
           
        case {'4'}
            
            path = "main_text_data/fig_4";
            
        case {'S6'}
            
            path = "main_text_data/fig_3/B_7";

        case {'S7A'}
            
            path = "SI_data/fig_S7/B_7";
            
        case {'S7B'}
            
            path = "SI_data/fig_S7/B_8";
            
        case {'S7C'}
            
            path = "SI_data/fig_S7/B_9";
            
        case {'S8'}
            
            path = "SI_data/fig_S8";
            

        otherwise

            fprintf(2,'error, only figures 2, 3a, 3b, 3c, 4, S6, S7a, S7b, S7c, S8 coded, not %s, return.\n',fig);

            return

    end

    set(0,'DefaultLegendInterpreter','latex')
    set(0,'DefaultTextInterpreter','latex')


    parameters = dlmread(strcat(path,"/plot_parameters.txt"));

    %%
    A = dlmread(strcat(path,"/Tevol_out_re"));
    B = dlmread(strcat(path,"/Tevol_out_im"));

    L=size(A,2);
    N=size(A,1);
    A=A+1i*B(1:N,1:L);

    B=dlmread(strcat(path,"/energy.txt"));

    E0=B(2);

    dt=0.05;
    T=dt*(N-1);

    ts=linspace(0,T,N)';

    for i=(N:-1:1)
        t=ts(i);
        A(i,:)=A(i,:)*exp(1i*E0*t);
    end

    A = A- mean(A);


    %% time-windowing

    T0 = parameters(1);

    for i=(N:-1:1)
        t=ts(i);
        A(i,:)=A(i,:)*exp(-0.5*(t/T0)^2);
    end


    %% tab with zeros in the time direction

    a = floor(log2(N));
    a = a+4;
    a = 2^a;
    B=zeros(a-N,L);
    A=[A;B];
    N = a;
    T = dt * N;


    %% Space Fourier Transform
    B = fft(A,[],2);

    k = linspace(0,2,L+1);
    k=k(1:L);

    % fix the phase of the real space fft
    for i=(1:L)
        B(:,i) = B(:,i) * exp(1i*pi*k(i)*(L/2-1));
    end


    %% Time Fourier transform and adjust minor issues

    ts = dt*(0:N-1);
    B = fft(B,[],1);

    %rescale by the right factor
    B = B * 4 * pi * dt / (L * T);
    %flip B over the omega axix, leaving the zero unchanged
    C = B(2:N,:);
    C = flipud(C);
    B = [ B(1,:) ; C ];


    %% plot

    %setup omega and k scale
    J = parameters(2);

    omega = 2 * pi * J / T * (0:N-1);

    ind = find(omega<6);
    B=B(ind,:);
    omega = omega(ind);

    B = abs(B);
    ind = find(omega<parameters(7));
    B(ind,:) = B(ind,:) * parameters(8);


    %% symmetrize w.r.t k\mapsto-k

    B = (B + fliplr(B))/2;


    %% adjust normalizations

    Max=max(max(abs(B)));
    B = B / Max;



    %% pseudo-color plot

    h=figure;
    h1=pcolor(k,omega,B);
    set(h1, 'EdgeColor', 'none');
    new_map = dlmread('paper_colormap.txt');
    colormap(h,new_map)


    hold on
    xlim([0,2])
    h=pcolor(-k,omega,B);
    set(h, 'EdgeColor', 'none');

    xlim([parameters(3),parameters(4)])
    ylim([parameters(5),parameters(6)])


    ytickformat('$%2.1f$')
    xtickformat('$%2.1f$')
    set(gca,'TickLabelInterpreter','latex')


    cb = colorbar;
    cb.TickLabelInterpreter = 'latex';
    cb.FontSize = 11;

    hold on
    xlabel("$k$ (in $2\pi/ c$)",'Interpreter','latex')
    ylabel("$\omega$ [meV]",'Interpreter','latex')
    set(gca,'linewidth',1,'fontsize',12)

    %%

    if (fig == "2")
        plot_modes_dispersion();
    end

    if (fig == "S6")
        experimental = @(x)(-1.402*cos(pi*x)+1.857);
        k_grid = linspace(0,2,100);
        plot(k_grid,experimental(k_grid),'c--','linewidth',2)
    end

    if (fig == "S7A" || fig == "S7B" || fig == "S7C")
        M = max(abs(B),[],1);
        h=figure(2);
        plot(k,M,'linewidth',1.5)
        xlabel("$k$ (in $2\pi/c$)",'Interpreter','latex')
        component = 'yy';
        ylabel(strcat("Max$\left|S^{",component,"}\right|$"),'Interpreter','latex')
        set(gca,'linewidth',1,'fontsize',12)
        ytickformat('$%2.1f$')
        xtickformat('$%2.1f$')
        set(gca,'TickLabelInterpreter','latex')
    end

end