function chi = chi_sqr_fixed(couplings)
%chi squared function, where parameters = [J, lamYZ, hz]
% lamAF and lamS are deduced from J


    %parameters obtained by matching first order perturbation theory with
    %Ref[18]
    
    J0=2.752;
    lamAF=0.148;
    lamS=0.240;
    
    %determine lamAF and lamS from J
    J=couplings(1);
    lamAF=1-(1-lamAF)*J0/J;
    lamS=lamS*J0/J;
    
    %call the chi squared function 
    chi = chi_sqr([J, lamAF, lamS, couplings(2), couplings(3)]);
    
end