function chi = chi_sqr(couplings)
%chi squared function between the 2 lowest energy bands of the model
% and the 2 lowest energy bands reported in Ref[18]

%files containing the relevant modes   
files = ["mode1.dat", "mode1b.dat";

    "mode2.dat", "mode2b.dat";

    "mode3.dat", "mode3b.dat";

    "mode4.dat", "mode4b.dat";

    "mode5.dat", "mode5b.dat"
];

dir = "../../main_text_data/fig_2/experimental_data/";

files = dir + files;

%functions fo folding k in the [0,\pi/2] interval
theta = @(x) (sign(x) + 1)/2;
g = @(k) k .* theta(1-k) + (2-k).*theta(k-1);
f = @(k) g(abs(k));

%compute the model dispersion on a L=12 sites system
bands = effective_bands(couplings);

%symmetrize dispersion from the [0,\pi/2] interval to the [-\pi/2,\pi/2]
%interval
%this is useful to have a better interpolation at k=0
bands=[fliplr(bands),bands(:,2:end)];
bands(1,1:end/2)=-bands(1,1:end/2);

chi=0;
figure(5)
hold off
for band_n=(1:2)
   %read data
   k=[]; e=[]; de=[];
   for i=(1:2)
        data=dlmread(files(band_n,i),',',1,0);
        k=[k;data(:,1)];
        e=[e;data(:,2)];
        de=[de;data(:,3)];
   end
   %fold experimental bands
   k=f(k);

   %interpolate simulated dispersion
   k_mod = bands(1,:);
   e_mod = bands(1+band_n,:);

   e_mod = interp1(k_mod',e_mod',k,'spline');

   %compute chi square
   chi_mode = sum( ((e_mod-e)./de).^2 );
   
   %plot
   plot(k,e,'o')
   hold on
   plot(k,e_mod,'-')

   chi = chi + chi_mode;

end
drawnow
    

