function bands = effective_bands(couplings)
%compute the dispersion of the lowest band
%returns a matrix bands, s.t.
% bands[1,:] stores the momentum
% bands[2,i] store the energy dispersion of the band

    N_bands = 1;
    
%% build the Hamiltonian of the system as a sparse matrix

    J=-couplings(1);
    lam1=-couplings(2);
    lam2=couplings(3);
    lamYZ=couplings(4);
    hy = couplings(5);
    
    
    global L



    sigmax=[0, 1; 1, 0];
    sigmay=[0, -1i; 1i, 0];

    I=@(d) speye(d);

    sz=@(j) kron(kron(I((2)^(j-1)),diag([1, -1])),I(2^(L-j)))/2;
    sx=@(j) kron(kron(I((2)^(j-1)),sigmax),I(2^(L-j)))/2;
    sy=@(j) kron(kron(I((2)^(j-1)),sigmay),I(2^(L-j)))/2;


    H=spalloc(2^L,2^L,0);

    for j=(1:L)
         H = H + J*hy*sy(j);
    end

    for j=(1:L-1)
         H = H + J*sz(j)*sz(j+1);
         H = H + J*lam2*( sx(j)*sx(j+1) + sy(j)*sy(j+1));
         staggering = (-1)^j;
         H = H + J*staggering*lamYZ* (sy(j)*sz(j+1) + sz(j)*sy(j+1));
    end
    H = H + J*sz(1)*sz(L);
    H = H + J*lam2*( sx(1)*sx(L) + sy(1)*sy(L));
    staggering = +1;
    H = H + J*staggering*lamYZ* (sy(1)*sz(L) + sz(1)*sy(L));


    for j=(1:L-2)
         H = H + J*lam1*sz(j)*sz(j+2);
    end
    H = H + J*lam1*sz(L-1)*sz(1);
    H = H + J*lam1*sz(L)*sz(2);
    
%%  find the lowest 5*L eigenvalues and eigenvectors

    [V,E] = eigs(H,5*L,'smallestreal');
    E=diag(E);
    %shift the energies, s.t. the ground-state energy is 0
    E=E-E(1);


    %find the energies corresponding to 4 momenta
    %(0:M)/L*2\pi
    M=L/4-1;
    k_vec=(0:M);
    energies=zeros(2,length(k_vec)); 
    
    %determine the momentum of the excited states by looking at which of the
    %excited states have a non-zero overlap with SX*|ground-state>
    for k=(0:M)
        %build k momentum sx operator
        SX=spalloc(2^L,2^L,0);
        for j=(1:L)
            SX = SX + sx(j)*exp(1i*2*pi*j*k/L);
        end

        GS=V(:,1);

        A=GS'*SX*V;
        A=abs(A).^2;

        ind = find(A>1e-2);

        tmp=E(ind);
        tmp=uniquetol(tmp,1e-3);
        tmp = sort(tmp);
        tmp = tmp(1:N_bands);
        energies(:,k+1) = tmp;
    end
    
    
    bands = [k_vec/L*2; energies];
    
end