function chi = chi_sqr(couplings)
%compute chi squared between the low-momentum dispersion of the
%quasiparticle band of
%   (1) the model in text with parameters coupling specified as
        %[J, lamAF, lamS, lamYZ, hz, hy]
%   (2) the experimental dispersion at B=7T reported in Ref[25]


chi=0;
figure(5)
hold off
for band_n=(1:1)
    
   bands = effective_bands(couplings);
   
   k =  bands(1,:);
   e_mod = bands(2,:);
    
   E0 = 1.857;
   t = -1.402;
   e = E0 + t * cos(pi*k);
   

   %compute chi square
   figure(5)
   hold off
   plot(k,e,'o')
   hold on
   plot(k,e_mod,'-')
   
   ind = find(abs(k-1)>0.51); 
   e=e(ind);
   e_mod=e_mod(ind);
   chi_mode = sum( (e_mod-e).^2 );
   chi = chi + chi_mode;
   
   

end
drawnow
    

