function convergence_analysis(fig)
    % function convergence_analysis(fig)
    % fig is figure number supplied as a character string 'S3', 'S5B' etc.
    % convergence_analysis('S3');  % plots Fig S3 of SI
    % convergence_analysis('S5B'); % plots Fig S5, panel B, of SI



    fig=upper(strtrim(fig)); % eliminate white spaces from start&end and convert to uppercase

    switch fig

        case {'S3'}

            paths = ["SI_data/fig_S3";"main_text_data/fig_2/simulation"];

        case {'S4'}

            paths = ["SI_data/fig_S4";"main_text_data/fig_4"];
            
        case {'S5A'}
            
            paths = ["SI_data/fig_S5/B_7";"main_text_data/fig_3/B_7"];
            
        case {'S5B'}
            
            paths = ["SI_data/fig_S5/B_8";"main_text_data/fig_3/B_8"];
            
        case {'S5C'}
            
            paths = ["SI_data/fig_S5/B_9";"main_text_data/fig_3/B_9"];

        otherwise

            fprintf(2,'error, only figures S3, S4, S5a, S5b, S5c coded, not %s, return.\n',fig);

            return

    end

    
    set(0,'DefaultLegendInterpreter','latex')
    set(0,'DefaultTextInterpreter','latex')

    parameters = dlmread(strcat(paths(2),"/plot_parameters.txt"));

    for plot_index = (1:2)

        path = paths(plot_index);

    %%
        A = dlmread(strcat(path,"/Tevol_out_re"));
        B = dlmread(strcat(path,"/Tevol_out_im"));

        L=size(A,2);
        N=size(A,1);
        A=A+1i*B(1:N,1:L);

        B=dlmread(strcat(path,"/energy.txt"));

        E0=B(2);

        dt=0.05;
        T=dt*(N-1);

        ts=linspace(0,T,N)';

        for i=(N:-1:1)
            t=ts(i);
            A(i,:)=A(i,:)*exp(1i*E0*t);
        end

        A = A- mean(A);


        %% time-windowing

        T0 = parameters(1);

        for i=(N:-1:1)
            t=ts(i);
            A(i,:)=A(i,:)*exp(-0.5*(t/T0)^2);
        end


        %% tab with zeros in the time direction

        a = floor(log2(N));
        a = a+4;
        a = 2^a;
        B=zeros(a-N,L);
        A=[A;B];
        N = a;
        T = dt * N;


        %% Space Fourier Transform
        B = fft(A,[],2);

        k = linspace(0,2,L+1);
        k=k(1:L);

        % fix the phase of the real space fft
        for i=(1:L)
            B(:,i) = B(:,i) * exp(1i*pi*k(i)*(L/2-1));
        end


        %% Time Fourier transform and adjust minor issues

        ts = dt*(0:N-1);
        B = fft(B,[],1);

        %rescale by the right factor
        B = B * 4 * pi * dt / (L * T);
        %flip B over the omega axix, leaving the zero unchanged
        C = B(2:N,:);
        C = flipud(C);
        B = [ B(1,:) ; C ];


        %setup omega and k scale
        J = parameters(2);

        omega = 2 * pi * J / T * (0:N-1);

        ind = find(omega<6);
        B=B(ind,:);
        omega = omega(ind);

        B = abs(B);


        %% symmetrize w.r.t k\mapsto-k

        B = (B + fliplr(B))/2;


        %% adjust normalizations

        Max=max(max(abs(B)));
        B = B / Max;

        %% convergence plot

        ks = floor(linspace(2,L/2,6));

        C = B(:,ks);
        shift = 1e-1;

        h=figure(3);
        hold on

        if (plot_index==1)
            style = "k-";
        else
            style = 'r--';
        end

        for k=(1:6)
           plot(omega,abs(C(:,k))+shift*k,style,'linewidth',1);
        end

        xlabel("$\omega$ [meV]",'Interpreter','latex')
        component = "xx";
        ylabel(strcat("$\mathcal{S}^{",component,"}$"),'Interpreter','latex')
        set(gca,'linewidth',1,'fontsize',12)

        xlim([parameters(5), parameters(6)])

    end

end