#ifndef __ITENSOR_SITEOP_H
#define __ITENSOR_SITEOP_H

#include "itensor/all.h"

using namespace itensor;

template <class Tensor>
class SiteOpt;

using SiteOp = SiteOpt<ITensor>;
using IQSiteOp = SiteOpt<IQTensor>;

template <class Tensor>
class SiteOpt
    {
    public:

	SiteOpt(){}

    SiteOpt(SiteSet const& sites, 
             int i, Tensor op);

    int i() const { return i_; }

    operator const Tensor&() const { return op_; }

    Tensor const&
    op() const { return op_; }

    private:

    int i_;
    Tensor op_;
    };



template <class Tensor>
SiteOpt<Tensor>::
SiteOpt(SiteSet const& sites, 
         int i, 
         Tensor op)
    {
    i_ = i;
    op_ = op;
    }
    
    
/*void applySiteOp(const IQSiteOp& Op, IQMPS& psi){
	int s = Op.i();
	psi.Aref(s)*=Op.op();
	psi.Aref(s).noprime(Site);
}

void applySiteOpDag(const IQSiteOp& Op, IQMPS& psi){
	int s = Op.i();
	auto op = Op.op();
	op.dag();
	op.prime(Site);
	op = op.mapprime(Site,2,0);
	psi.Aref(s)*=op;
	psi.Aref(s).noprime(Site);
}*/

void applySiteOp(const SiteOp& Op, MPS& psi){
	int s = Op.i();
	psi.Aref(s)*=Op.op();
	psi.Aref(s).noprime(Site);
}

void applySiteOpDag(const SiteOp& Op, MPS& psi){
	int s = Op.i();
	auto op = Op.op();
	op.dag();
	op.prime(Site);
	op = op.mapprime(Site,2,0);
	psi.Aref(s)*=op;
	psi.Aref(s).noprime(Site);
}

#endif

