#ifndef __ITENSOR_DSF_OBSERVER_H
#define __ITENSOR_DSF_OBSERVER_H

#include "SiteOp.h"
#include "itensor/all.h"

using namespace itensor;
using namespace std;

class DSF_Observer : public TEvolObserver
{
	public:
		DSF_Observer(const vector<SiteOp>& B, const MPS& GS, const Args& args = Global::args());
		
		void measure(const MPS& psi, const Args& args = Global::args());
	
	private:
		int L_;
		vector<vector<Complex>> AB_exp_;
		vector<SiteOp> B_;
		MPS GS_;
		double norm_=1;
		bool first_measurement_done_=false;
		string filename_re, filename_im, filename_m;
};

DSF_Observer :: DSF_Observer(const vector<SiteOp>& B, const MPS& GS, const Args& args):
	TEvolObserver(args)
{
	B_=B;
	L_=B.size();
	GS_=GS;
	auto filename = args.getString("file_out","Tevol_out");
	filename_re = filename+"_re";
	filename_im = filename+"_im";
	filename_m = filename+"_m";
	//system("rm -f "+filename_re);
	//system("rm -f "+filename_im);
}

void DSF_Observer :: measure(const MPS& psi, const Args& args)
{
	TEvolObserver::measure(args);
		
	ofstream fout_re, fout_im, fout_m;

	fout_re.open(filename_re,std::ofstream::app);
	fout_im.open(filename_im,std::ofstream::app);
	fout_m.open(filename_m,std::ofstream::app);
	fout_re.precision(10);
	fout_im.precision(10);
	for (int j=0; j<L_ ; j++){
		auto phi=GS_;
		applySiteOpDag(B_.at(j),phi);
		auto over=overlapC(phi,psi)*norm_;
		fout_re << over.real() << "\t";
		fout_im << over.imag() << "\t";
	}
	for (int j=1; j<L_ ; j++){
		auto ind = rightLinkInd(psi,j);
		fout_m << ind.m() << "\t";
	}
	fout_re << "\n";
	fout_im << "\n";
	fout_m << "\n";
	fout_re.close();
	fout_im.close();
	fout_m.close();

	if (!first_measurement_done_){
		norm_ = psi.norm();
		first_measurement_done_ = true;
	}
}
    
#endif
