#!/bin/bash
#
# Check if pdflatex has defined location
command -v pdflatex || {
	 echo "pdflatex could not be found.";
	 echo "Please make sure pdflatex is reachable through the PATH environment variable, or replace all instances of pdflatex in this script by the full path to pdflatex."
	 return;
}
#
#
# Compile supplemental figures S9, S10, S11, S12
pdflatex --enable-write18 --extra-mem-bot=60000000 --extra-mem-top=60000000 -synctex=1 -interaction=nonstopmode figureS9.tex
pdflatex --enable-write18 --extra-mem-bot=60000000 --extra-mem-top=60000000 -synctex=1 -interaction=nonstopmode figureS10.tex
pdflatex --enable-write18 --extra-mem-bot=60000000 --extra-mem-top=60000000 -synctex=1 -interaction=nonstopmode figureS11.tex
pdflatex --enable-write18 --extra-mem-bot=60000000 --extra-mem-top=60000000 -synctex=1 -interaction=nonstopmode figureS12.tex
