#!/bin/bash
#
# Check if pdflatex has defined location
command -v pdflatex || {
	 echo "pdflatex could not be found.";
	 echo "Please make sure pdflatex is reachable through the PATH environment variable, or replace all instances of pdflatex in this script by the full path to pdflatex."
	 return;
}
#
#
# Compile supplemental figures S1-S8 and S13-S15
pdflatex -interaction=nonstopmode figureS1.tex
pdflatex --enable-write18 --extra-mem-bot=60000000 --extra-mem-top=60000000 -synctex=1 -interaction=nonstopmode figureS2.tex
pdflatex --enable-write18 --extra-mem-bot=60000000 --extra-mem-top=60000000 -synctex=1 -interaction=nonstopmode figureS3.tex
pdflatex -interaction=nonstopmode figureS4.tex
pdflatex --enable-write18 --extra-mem-bot=60000000 --extra-mem-top=60000000 -synctex=1 -interaction=nonstopmode figureS5.tex
pdflatex -interaction=nonstopmode figureS6.tex
pdflatex -interaction=nonstopmode figureS7.tex
pdflatex -interaction=nonstopmode figureS8.tex
pdflatex -interaction=nonstopmode figureS13.tex
pdflatex -interaction=nonstopmode figureS14.tex
pdflatex --enable-write18 --extra-mem-bot=60000000 --extra-mem-top=60000000 -synctex=1 -interaction=nonstopmode figureS15.tex
