#!/bin/bash
#
# Check if pdflatex has defined location
command -v pdflatex || {
	 echo "pdflatex could not be found.";
	 echo "Please make sure pdflatex is reachable through the PATH environment variable, or replace all instances of pdflatex in this script by the full path to pdflatex."
	 return;
}
#
#
# Compile figures
pdflatex -interaction=nonstopmode figure1.tex
pdflatex --enable-write18 --extra-mem-bot=60000000 --extra-mem-top=60000000 -synctex=1 -interaction=nonstopmode figure2.tex
pdflatex --enable-write18 --extra-mem-bot=60000000 --extra-mem-top=60000000 -synctex=1 -interaction=nonstopmode figure3.tex
pdflatex -interaction=nonstopmode figure4.tex
