close all; clear; clc;

%% Show the effects of windowing on the spectrum
N = 2^8; t = linspace(0,1,N+1); t(end) = []; dt = t(2)-t(1);
y = @(t) sin(2*pi*t*20) + sin(2*pi*t*40.2) + sin(2*pi*t*60.5);

v = linspace(0,1-1/N,N) + (mod(N,2)/N-1)/2; v = v/dt;

figure(1); clf;
subplot(1,2,1); hold on
plot(t,boxcar(N));
plot(t,hann(N));
plot(t,flattopwin(N));

grid on; box on; axis square;
xlabel('t'); ylabel('w');
ylim([-0.5 1.5]);

subplot(1,2,2); hold on
h(1) = plot(v,abs(fftshift(fft( boxcar(N)'.*y(t) )/N)));
s = mean(hann(N));
h(2) = plot(v,abs(fftshift(fft( hann(N)'.*y(t)/s )/N)));
s = mean(flattopwin(N));
h(3) = plot(v,abs(fftshift(fft( flattopwin(N)'.*y(t)/s )/N)));

grid on; box on; axis square;
xlim([0 80]);
xlabel('v'); ylabel('fft(w.*y)');
legend(h,'boxcar','hann','flattop');