function dedt = wave_2d_odefun_3(t,e,f,v,X,Y,N,lap)
% Sigmoid envelope in X and Y
s = 20; % Step gradient
SY = ...
sigmoid_step(Y,1,0,0.5,s).*(Y>0)+...
sigmoid_step(Y,0,1,-0.5,s).*(Y<=0);
SX = sigmoid_step(X,1,0,0.8,s);

% Index of refraction landscape
n = ones(size(X)); n(X<0.2&X>-0.2) = 1/2;

% Loss constructed based on the X and Y envelope
S = SX.*SY; l = (1-S(:));

% Driver frequency
d = 2*pi*f*cos(2*pi*t*f)*0.5;
isd = [true(N,1) false(N,N-1)]; % Drive only the left edge

% First derivative - driver and losses
e1 = e(N^2+1:end) - 50*l.*e(1:N^2);
e1(isd(:)) = SY(:,1)*d;

% Second derivative - Wave propagation
e2 = (2*v.*n(:)).^2.*lap(e(1:N^2));

% Overall derivative
dedt = [e1; e2];
end