function y = sigmoid_step(x,alpha,beta,center,slope)
%% y = sigmoid_step(x,alpha,beta,center,slope)
% Sigmoid from 'alpha' to 'beta' with halfway point
% with 'slope' at 'center'.
%
% Written by Marcin Konowalczyk
% Timmel Group @ Oxford University

slope = abs(slope); % Slope determined by the 'alpha' and 'beta' parameters
if alpha == beta
    y = ones(size(x)).*alpha;
    return
elseif alpha < beta
    y = (beta-alpha)./(1+exp(-(x-center)*slope*4)) + alpha;
else % alpha > beta
    y = -(alpha-beta)./(1+exp(-(x-center)*slope*4)) + alpha;
end
end