function M = resonator_alignment_make_mirror(g,s)
%% Make complex points defining a mirror
%
% g - Geometrical factor of the mirror
% s - Mirror selector (1=left, r=right)

l = 2; % Cavity length
N = 1e2; % Number of points in the mirror

%% Make the mirror
if g == 1 % Special case
    X = zeros(1,2*N);
    Y = linspace(-0.5,0.5,2*N);
else
    if g < 1
        xs = 1;
    elseif g > 1
        g = 2-g; xs = -1;
    end
    r = -(l/(g-1)); % Radius
    r2 = 1/8*((8*l)/(1-g)-sqrt(-16+(64*l^2)/(1-g)^2)); % x-range to get a small mirror
    if ~isreal(r2); r2 = r; end
    x = linspace(0,r2,N);
    y = sqrt(x.*(x-g*x-2*l)./(g-1));
    Y = [fliplr(y) -y];
    X = xs*[fliplr(x) x];
    X(N) = []; Y(N) = []; % Remove duplicate middle points
end
M = X+1i*Y;

%% Linearlise
t = [0 cumsum(abs(diff(M)))]; t = t/t(end); % Piecewise arclength along the curve
ti = linspace(0,1,N);
M = interp1(t,X,ti,'spline') + 1i*interp1(t,Y,ti,'spline');

%% Shift mirrors to correct positions
if s == 1
    M = M-l/2;
elseif s == 2
    M = -conj(M)+l/2;
else
    error('Invalid mirror selector');
end
end