function y = resonator_alignment_impactmap(yc,M1,M2)
%% Map the impact of the ray onto the mirror
if real(yc(1))<0
    [~,grad] = resonator_alignment_bouncefun(yc(1),M1);
else
    [~,grad] = resonator_alignment_bouncefun(yc(1),M2);
end
theta = atan2(grad,1) + randn*1e-3; % Angle of surface normal
y = [yc(1) exp(1i*theta)*conj(exp(1i*-theta)*yc(2))];
end