function [v,isterminal,direction] = resonator_alignment_eventfun(t,yc,M1,M2)
%% Event function for the ode solver
isterminal = true; % Stop on event
direction = -1; % Approach from positive v
v = 1.5-abs(yc(1)); % Hit a killplane outside of the resonator
if v < 0, return, end
if real(yc(1))<0 % Bounce of M1
    [v,~] = resonator_alignment_bouncefun(yc,M1);
else % Bounce of M2
    [v,~] = resonator_alignment_bouncefun(yc,M2);
end
end