function [pf,fval,path] = random_search_function(f,p0,tol,step_size)
if nargin < 3 || isempty(tol), tol = 1e-4; end
if nargin < 4 || isempty(step_size), step_size = 1; end
stall = 0; path = p0; % Initialise
pf = p0; fval = f(p0); % Starting point p0
for j = 1:1000 % Limit number of iterations to 1e3
    dp = step_size.*randn(1,2);
    pnew = pf + dp; fnew = f(pnew);
    if fnew < fval
        pf = pnew; fval = fnew; stall = 0;
        path = [path; pf]; %#ok<AGROW>
    elseif stall >= 15 % Standing in one place for too long
        stall = 0; step_size = step_size/2;
    else
        stall = stall + 1;
    end
    if step_size < tol; break; end
end
end
