function [w,p,s] = p_to_window(p,N)
%% Construct a scaled window from its components
n = 0:(N-1); % Window axis
p = [p(1)-p(2) p]; % Set edge samples to 0
b = bsxfun(@times,cos((0:2:4)'*pi*n/(N-1)),sign(mod(1:3,2)-1/2)'); % Basis
w = p*b;
% Scale the window and the components to unit magnitude
s = max(abs(w)); 
w = w/s; p = p/s; p = [p(2)-p(3) p(2:3)];
end