close all; clear; clc;

%% Simulate
b = 0.1;
h = 1/2;
X = exp(1i*(0:2)*2*pi/3);
x0 = [1+1i; 0];
S = @(x) sum((X-x(1))./(abs(X-x(1)).^2+h^2).^(5/2));
dxdt = @(t,x) [0 1;-1 -b]*x + [0;1]*S(x(1));
[t,y] = ode23(dxdt,[0 20],x0);
[~,I] = min(abs(X-y(end))); % Find which magnet did the pendulum end up at

%% Plot
figure(1); clf; hold on;
plot(y(:,1));
plot(X,'k.');
axis square; box on;
grid on;
xlim([-1 1]*2); ylim([-1 1]*2);
