close all; clear; clc;

%% Make flattop window
% Make a flattop window according to the way it's made in Matlab
N = 1e2+1; n = 0:(N-1);
b = bsxfun(@times,cos((0:2:8)'*pi*n/(N-1)),sign(mod(1:5,2)-1/2)');
a = [215.57895 416.63158 277.263158 83.578947 6.947368]/1e3; % Coefficients
w = bsxfun(@times,a',b)';

%% Plot
figure(1); clf;
plot(n,w,'--');
hold on;
plot(n,sum(w,2),'k-'); % Sum of oscillations
plot(n,flattopwin(numel(n)),'r.'); % Matlab's flattopwin function
xlim([0 N-1]);
grid on; box on;
xlabel('Samples'); ylabel('Window'); title('Flattop window');
