close('all'); clear; clc;

%%
y = randn(1,1e3); % random input
fun1 = @(x) abs(ifft(fft(x))); % absolute value
fun2 = @(x) real(ifft(fft(x))); % real part
N = 200;

x = 1:N;
for n = x
    yn1 = y; yn2 = y;
    for j = 1:n % Apply 'fun' n times
        yn1 = fun1(yn1);
        yn2 = fun2(yn2);
    end
    e1(n) = max( y - yn1 )/eps;
    e2(n) = max( y - yn2 )/eps;
end

% Gradients of each of the errors
g1 = (e1)/(1:N); g2 = (e2)/(1:N);

%%
figure(1); clf;
h = plot(x,e1,'-',x,e2,'-'); hold on;
plot(x,x*g1,'k--',x,x*g2,'k--');
grid on; box on;
xlabel('times ifft(fft(x)) applied');
ylabel('max numerical round-off error / eps');
title(sprintf('g1 = %.2f, g2 = %.2f',g1,g2));
legend(h,'abs(...)','real(...)','location','northwest');