close all; clear; clc;

%%
N = 9; % Number of sampling points
y = @(x) -sin(2*pi*1*x); % 1Hz Signal
t1 = linspace(0,1,N+1); t1(end) = []; % N+1 time-sampling
t2 = linspace(0,1,N); % Edge-to-edge tiesampling
t3 = linspace(0,1,N); % Edge-to-edge tiesampling

% Plot 1
dt1 = t1(2)-t1(1); dt2 = t2(2)-t2(1); dt3 = t3(2)-t3(1);
v1 = linspace(0,1-1/N,N); v1 = v1-v1(floor(N/2)+1); v1 = v1/dt1;
v2 = linspace(0,1-1/N,N); v2 = v2-v2(floor(N/2)+1); v2 = v2/dt2;
v3 = linspace(0,1-1/N,10*N); v3 = v3-v3(floor((10*N)/2)+1); v3 = v3/dt3;

cm = lines;
clear h;
figure(1); clf;
subplot(1,2,2)
h(1) = stem(v1,abs(fftshift(fft(y(t1))))/N,'marker','o','color',cm(1,:)); hold on;
plot(v3,abs(fftshift(fft(y(t3),10*N)))/N,'k-');
h(2) = stem(v2,abs(fftshift(fft(y(t2))))/N,'marker','s','color',cm(2,:));
grid on; box on; axis square;
xlim([-3 3]);
xlabel('frequency'); ylabel('fft(y)');

% Plot 2
% Time axis of the second period
t21 = t1 + t1(end) + dt1;
t22 = t2 + t2(end) + dt2;

clear h;
subplot(1,2,1)
t_dense = linspace(0,2,1e3);
h(1) = plot(t_dense,y(t_dense),'k-'); hold on;
cm = lines;
h(2) = plot(t1,y(t1),'o','color',cm(1,:),'MarkerSize',4);
h(3) = plot(t21,y(t1),'o--','color',cm(1,:),'MarkerSize',4);
h(4) = plot(t2,y(t2),'s','color',cm(2,:),'MarkerSize',4);
h(5) = plot(t22,y(t2),'s--','color',cm(2,:),'MarkerSize',4);
grid on; box on; xlim([0 2]); axis square;
xlabel('t'); ylabel('y');
