close all; clear; clc;

%%
N = 101;
x = linspace(-10,10,N);
k_dense = linspace(-5,5,1e3);
a = 1;
y = @(x) exp(-a.*(x).^2);
Ye = @(k) sqrt(pi/a).*exp(-pi.^2.*k.^2./a);

figure(1); clf;

subplot(2,1,1);
stem(x,y(x));
xlabel('x'); grid on; title('time domain'); box on;
subplot(2,1,2); hold on
plot(k_dense,Ye(k_dense),'g'); xlabel('k'); grid on; title('exact fourier transform');

dx = x(2)-x(1);
k2 = linspace(0,1-1/N,N); k2 = k2-k2(floor(N/2)+1);
k2 = k2./dx;
plot(k2,dx.*abs(fftshift(fft(y(x)))),'o');
hold on;

temp = @(w)...
    sum(...
        bsxfun(@times,...
            y(x),...
            exp(...
                -2.*pi .* 1i .* w' .* (x-x(1))...
            )...
        ),2);

plot(k_dense,dx.*abs(temp(k_dense)),'r-'); grid on
title('DFT');
grid on; box on;


