close all; clear; clc;

%% Test convolution theorem numerically
N = 1e3; x = randn(N,1); y = randn(N,1); % Two random signals
XY1 = fft(x.*y); % DFT of a product
XY2 = cconv(fft(x),fft(y),N)/N; % Convolution of DFTs
delta = max(abs(XY1-XY2))/(N*eps); % Max difference

fprintf('Delta = %.1f eps\n',delta);