close all; clear; clc;

%%

N = 500; t = linspace(0,1,N+1); t(end) = []; dt = t(2)-t(1);
v = linspace(0,1-1/N,N) + (mod(N,2)/N-1)/2; v = v/dt; % Frequency axis

y = @(f) sin(2*pi*t*f);
w1 = kaiser(N)'; w1 = w1./mean(w1);
w2 = boxcar(N)'; w2 = w2./mean(w2);
w3 = hann(N)'; w3 = w3./mean(w3);
w4 = flattopwin(N)'; w4 = w4./mean(w4);

figure(1); clf;
cm = lines;

s1 = subplot(1,2,1); hold on;

plot(t,w1.*y(5)+9,'color',cm(1,:));
plot(t,w1.*y(20)+6,'color',cm(2,:));
plot(t,w1.*y(5).*y(20)+3,'color',cm(4,:));
plot(t,w1.*y(20).*y(20),'color',cm(5,:));

%xlim([-1 1]*100); ylim([0 0.6]);
grid on; box on; axis square;
s1.YTick = [0 3 6 9];
s1.YTickLabel = '';
%s1.XGrid = 'off';
ylim([-2 12]);
xlabel('time'); ylabel('signal');


s2 = subplot(1,2,2); hold on;
plot(v,abs(fftshift(fft(w1.*y(5))))/N+.75,'color',cm(1,:));
plot(v,abs(fftshift(fft(w1.*y(20))))/N+.75,'color',cm(2,:));
plot(v,abs(fftshift(fft(w1.*y(5).*y(20))))/N+1.5,'color',cm(4,:));
plot(v,abs(fftshift(fft(w1.*y(20).*y(20))))/N,'color',cm(5,:));

plot([-20 -25],[1.25 1.5],'k:'); plot([-20 -15],[1.25 1.5],'k:');
plot([20 25],[1.25 1.5],'k:'); plot([20 15],[1.25 1.5],'k:');
plot([-20 -40],[0.75 0.5],'k:'); plot([-20 0],[0.75 0.5],'k:'); plot([-40 -40],[0.5 0.25],'k:');
plot([20 40],[0.75 0.5],'k:'); plot([20 0],[0.75 0.5],'k:'); plot([40 40],[0.5 0.25],'k:');
grid off; box on; axis square;
xlim([-1 1]*50); ylim([0 0.6+1.5-0.25]);
xlabel('frequency'); ylabel('fft( signal )')
s2.XTick = [-40 -20 0 20 40];
s2.YTick = [[0 0.25 0.5] [0 0.25 0.5]+0.75 [0 0.25 0.5]+1.5];
s2.YTickLabel = '';

grid on