close all; clear; clc;

%% Make signal
s = peaks(20); s = s(:);
s = decimate(s,10); s(end+1) = s(end);
N = numel(s);
theta = linspace(0,2*pi,N+1); theta(end) = [];
t = linspace(0,1,N+1); t(end) = []; dt = t(2)-t(1); % Time axis
v = linspace(0,1-1/N,N) + (mod(N,2)/N-1)/2; v = v/dt; % Frequency axis

% Add some interesting frequency components
s = s+(exp(-(t-0.3).^2*10).*1.*sin(2*pi*t*48))';
s = s.*hann(numel(s));

%% Plot circular signal
alpha = 0.5;
d1 = s;
d1 = d1./max(d1)*(1-alpha)*0.8;
d1 = d1 + alpha;

figure(1); clf;
polaraxes; hold on;
cm = viridis(numel(d1)-1);
polarplot(theta,alpha.*ones(size(theta)),'k--');
for j = 1:(numel(d1)-1)
    polarplot([theta(j) theta(j+1)],[d1(j) d1(j+1)],'color',cm(j,:),'linewidth',1);
    %patch([x(j) x(j+1) x(j+1) x(j)],[s(j) s(j+1) 0 0],cm(j,:),'edgecolor','none','facealpha',0.15);
end
rlim([0 1]);
a = gca;
a.RTickLabel = [];
a.ThetaTick = 0:30:330;
a.ThetaTickLabel = round(interp1(theta,t,(0:30:330)/360*2*pi),2);

%% Plot circular fft
d2 = abs(fft(s));
alpha = 0.5;
d2 = d2./max(d2)*(1-alpha)*0.8 + alpha;
figure(1); clf;
polaraxes; hold on;
cm = viridis(numel(d2)-1);
polarplot(theta,alpha.*ones(size(theta)),'k--');
for j = 1:(numel(d1)-1)
    polarplot([theta(j) theta(j+1)],[d2(j) d2(j+1)],...
        '.-','color',cm(j,:),'linewidth',1,'markersize',6);
end
rlim([0 1]);
a = gca;
a.RTickLabel = [];
a.ThetaTickLabel = [];
cb = colorbar; cb.Label.String = 'frequency / Hz';
colormap(cm);
caxis([-20 20]);