L=0.2;
f_0=3.517257185*10^8;% [MHz]
m=(132.90545/6.02e23)/1000; % [kg]
c=299792458; % [m/s]
k=1.3806488*10^(-23); % [m^2*kg/s^2]
hbar=1.05457173*10^(-34); % [m^2*kg/s]
dip=3.8014*10^(-29); % [C*m]
Av=6.02*10^23;
gamma_N=2*pi*5.234; % [MHz]
e_psi=8.854187817*10^(-12); % [F/m]
f_1=3.517257185*10^8;%

% Create data
FIT3=FIT2(:,3:end);
t=linspace(0,10800,size(FIT3,2));

gamma_D=FIT3(2,:);
gamma_N=5.234+1.16e-19*(FIT3(1,:).*FIT3(2,:)*2*c*hbar*e_psi)/(L*dip^2*2*pi*f_1*(pi*log(2))^0.5);
density=(FIT3(1,:).*FIT3(2,:)*2*c*hbar*e_psi)/(L*dip^2*2*pi*f_1*(pi*log(2))^0.5)*1e-6;
d=FIT3(1,:).*FIT3(2,:)./(gamma_N*(pi*log(2))^0.5);
logd=log10(d);

for i=1070:length(logd)-1000 %% correct peaks due to weird width fit
    if logd(i)>1.025*logd(i-1)||logd(i)<0.975*logd(i-1)
        logd(i)=logd(i-1);
    end
    
end

% Place axes at (0.1,0.1) with width and height of 0.8
figure('color', 'w');
handaxes1 = axes('Position', [0.12 0.12 0.8 0.8]);

% Main plot
plot(t,smooth(logd,1))
xlabel('Time (s)')
ylabel('Log(Optical Depth)') % left y-axis
set(handaxes1, 'Box', 'off')
xlim([0 10800]);
ylim([min(logd) max(logd)])

% Adjust XY label font
handxlabel1 = get(gca, 'XLabel');
set(handxlabel1, 'FontSize', 16, 'FontWeight', 'bold')
handylabel1 = get(gca, 'ylabel');
set(handylabel1, 'FontSize', 16, 'FontWeight', 'bold')

% Place second set of axes on same plot
handaxes2 = axes('Position', [0.6 0.23 0.25 0.25]);
plot(t-10800, smooth(logd,1), 'r')
set(handaxes2, 'Box', 'off')
xlabel('t (s)')
 xlim([-200 0]);
ylabel('log(d)')

% Adjust XY label font
set(get(handaxes2, 'XLabel'))
set(get(handaxes2, 'YLabel'))

% Add another set of axes
handaxes3 = axes('Position', [0.2 0.23 0.25 0.25]);
plot(t, smooth(logd,1), 'm')
set(handaxes2, 'Box', 'off')
xlabel('t (s)')
ylabel('log(d)')
xlim([0 30]);

export_fig('file_name','-pdf','-q50')
