% clear all
% filename='data\big150719.dat';
% [Time,Fiber,Cell,LIAD]=importfile2(filename);
% I = isnan(Fiber);
% IndI=find(I);
% SizeI=length(IndI);
clear all
filename='data\big150719.dat';
[Time,Fiber,Cell,LIAD]=importfile2(filename,1,100000);
I = isnan(Fiber);
IndI=find(I);
SizeI=length(IndI);
figure('color', 'w');
i=4;
    Ce=Cell(IndI(i)-1000:IndI(i)-1);
    Fib=Fiber(IndI(i)-1000:IndI(i)-1)';
%     Fib=smooth(Fib,100)';
    [freq,extr]=IndexToFreq5(linspace(1,1000,1000),Ce,[462;513]);
%     Co0=[0.3029;197.9903;0.0070;0.0094];
%     Co0=[200;174;0.078;0.013;0.001];
%  Co0=[100;200;5;0.0532;0.0122;0];
Co0=[1;400;0.062590258818044;0.012222235784676;-2.635678792383121e-06];
    h(1)=subplot(2,1,1)
[Co1,resnorm,residual,exitflag,output,lambda,jacobian]=lsqcurvefit(@DopplerCsVoigt2VarGammaSelfBroad,Co0,freq,Fib,[0,150,Co0(3:4)'*0.95,Co0(5)*1.05],[1e5,1000,Co0(3:4)'*1.05,Co0(5)*0.95]);%
[Q,R] = qr(jacobian,0);
mse = sum(abs(residual).^2)/(size(jacobian,1)-size(jacobian,2));
Rinv = inv(R);
Sigma = Rinv*Rinv'*mse;
se1 = sqrt(diag(Sigma));
FIT1=[Co1 full(se1)] 

plot(freq,Fib,'r')
    hold on
    prism
    plot(freq,DopplerCsVoigt2VarGammaSelfBroad(Co1,freq),'b')
    Co1;
        ylabel('Signal')
        
L=0.2;
f_0=3.517257185*10^8;% [MHz]
m=(132.90545/6.02e23)/1000; % [kg]
c=299792458; % [m/s]
k=1.3806488*10^(-23); % [m^2*kg/s^2]
hbar=1.05457173*10^(-34); % [m^2*kg/s]
dip=3.8014*10^(-29); % [C*m]
Av=6.02*10^23;
gamma_N=2*pi*5.234; % [MHz]
e_psi=8.854187817*10^(-12); % [F/m]
f_1=3.517257185*10^8;%

gamma_D=FIT1(2,1);
gamma_N=5.234+1.16e-19*(FIT1(1,1).*FIT1(2,1)*2*c*hbar*e_psi)/(L*dip^2*2*pi*f_1*(pi*log(2))^0.5);
density1=(FIT1(1,1).*FIT1(2,1)*2*c*hbar*e_psi)/(L*dip^2*2*pi*f_1*(pi*log(2))^0.5)*1e-6;
d1=FIT1(1,1).*FIT1(2,1)./(gamma_N*(pi*log(2))^0.5);
gamma_N1=gamma_N;
 d1un=d1*(FIT1(1,2)/FIT1(1,1)+FIT1(2,2)/FIT1(2,1));
 xlim([-3000 3700]);   
     ylim([0.01 0.1])
    h(2)=subplot(2,1,2)
    i=45;
    Ce=Cell(IndI(i)-1000:IndI(i)-1);
    Fib=Fiber(IndI(i)-1000:IndI(i)-1)';
%     Fib=smooth(Fib,100)';
    [freq,extr]=IndexToFreq5(linspace(1,1000,1000),Ce,[462;513]);
%     Co0=[0.3029;197.9903;0.0070;0.0094];
%     Co0=[200;174;0.078;0.013;0.001];
%  Co0=[100;200;5;0.0532;0.0122;0];
Co0=[1000;4.228513560526395e+02;0.058461067661379;0.012327775725231;-2.378700153543626e-06];

[Co2,resnorm,residual,exitflag,output,lambda,jacobian]=lsqcurvefit(@DopplerCsVoigt2VarGammaSelfBroad,Co0,freq,Fib,[0,150,Co0(3:4)'*0.95,Co0(5)*1.05],[1e5,1000,Co0(3:4)'*1.05,Co0(5)*0.95]);%
[Q,R] = qr(jacobian,0);
mse = sum(abs(residual).^2)/(size(jacobian,1)-size(jacobian,2));
Rinv = inv(R);
Sigma = Rinv*Rinv'*mse;
se2 = sqrt(diag(Sigma));
FIT2=[Co2 full(se2)] 
    plot(freq,Fib,'r')
    hold on
    plot(freq,DopplerCsVoigt2(Co2,freq),'b')
        Co2;
        xlabel('Detuning (MHz)')
        ylabel('Signal')
            
        
L=0.2;
f_0=3.517257185*10^8;% [MHz]
m=(132.90545/6.02e23)/1000; % [kg]
c=299792458; % [m/s]
k=1.3806488*10^(-23); % [m^2*kg/s^2]
hbar=1.05457173*10^(-34); % [m^2*kg/s]
dip=3.8014*10^(-29); % [C*m]
Av=6.02*10^23;
gamma_N=2*pi*5.234; % [MHz]
e_psi=8.854187817*10^(-12); % [F/m]
f_1=3.517257185*10^8;%

gamma_D=FIT2(2,1);
gamma_N=5.234+1.16e-19*(FIT2(1,1).*FIT2(2,1)*2*c*hbar*e_psi)/(L*dip^2*2*pi*f_1*(pi*log(2))^0.5);
density2=(FIT2(1,1).*FIT2(2,1)*2*c*hbar*e_psi)/(L*dip^2*2*pi*f_1*(pi*log(2))^0.5)*1e-6;
d2=FIT2(1,1).*FIT2(2,1)./(gamma_N*(pi*log(2))^0.5);
gamma_N2=gamma_N;
 d2un=d2*(FIT2(1,2)/FIT2(1,1)+FIT2(2,2)/FIT2(2,1));        

 ylim([0.01 0.1])
 
 
 
set(h(1),'xticklabel',[]);
pos=get(h,'position');
bottom=pos{2}(2);
top=pos{1}(2)+pos{1}(4);
plotspace=top-bottom;
pos{2}(4)=plotspace/2;
pos{1}(4)=plotspace/2;
pos{1}(2)=bottom+plotspace/2;

set(h(1),'position',pos{1});
set(h(2),'position',pos{2});

linkaxes(h,'x');
Apr1=[FIT1(1,1) FIT1(1,2)]
OD1=[d1 d1un]
gamma_N1
density1
Apr2=[FIT2(1,1) FIT2(1,2)]
num2=[d2 d2un] 
gamma_N2
density2
