%% Visualise Noise in the data 
close all
load('Fritz99_Fit_5.mat')

t_start = 0;    % Start time of sampling   
t_end = 10;     % End time of sampling   
inc = 0.5;      % Sampling interval
sigma = [0.3,1,20];    % Noise parameter
tf = linspace(t_start,t_end);
ti = tf;

[beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta,T0,~] = Theta_func_SD(Theta_s);
Y0 = [T0,0,0,1,0,0,0];
sol =  ode45(@(t,Y) SD(t,Y,beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta), tf, Y0);   
Y = deval(sol,ti)';
Y1 = Y(:,4);  % Viral Titer
Y2 = Y(:,7);  % Symptom Score
Y3 = Y(:,6);  % Cytokine

noise_vec = 1.96*sigma(1);
yu = 10.^(noise_vec).*Y1; 
yl = 10.^(-noise_vec).*Y1; 
figure
hold on
plot(ti,yu,'r')
plot(ti,yl,'r')
plot(ti,Y1,'b')
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
set(gca, 'YScale', 'log')
box on
shg


noise_vec = 1.96*sigma(2);
yu = min(Y2 + noise_vec,2*Y2); 
yl = max(0,Y2 - noise_vec); 
figure
hold on
plot(ti,yu,'r')
plot(ti,yl,'r')
plot(ti,Y2,'b')
xlabel('Time (Days)','FontSize',22)
ylabel('Symptom Score','FontSize',22)
box on
shg

noise_vec = 1.96*sigma(3);
yu = min(Y3 + noise_vec,2*Y3); 
yl = max(0,Y3 - noise_vec); 
figure
hold on
plot(ti,yu,'r')
plot(ti,yl,'r')
plot(ti,Y3,'b')
xlabel('Time (Days)','FontSize',22)
ylabel('Cytokine Level','FontSize',22)
box on
shg


