%% SD Symptom Score Local SA
clear all
sav = 1;
z = 2;           % 1: Normal omega, eta; 2: rescaled
t_start = 0;     % Start time of sampling   
t_end = 50;      % End time of sampling   
inc = 0.01;      % Sampling interval
sigma = 0.3;     % Noise parameter
sc = eps*ones(10,1);
N = 20;


theta1 = 1;
theta2 = 1;
theta1_vec = 10.^linspace(-1,1,N);  % omega_2
theta2_vec = 10.^linspace(-1,1,N);  % eta

l1 = length(theta1_vec);
l2 = length(theta2_vec);
res_mat = zeros(l1,l2,4);

tic
W = 5;
for i = 1:l1
    if floor(i/W) == i/W
        disp(i);
    end
for j = 1:l2
if z == 1
G = [theta1_vec(i), theta2_vec(j),1,1];
elseif z == 2
G = [theta1_vec(i), theta1_vec(i)*theta2_vec(j),1,1];
end
[dmat,~,t] = gen_data_SD(1,sc,G,sigma,t_start,t_end,inc,1);
res_mat(j,i,:) = biomarker(t,dmat);
% res_mat(j,i,:) = max(dmat);
end
end
toc

% vq = griddata(theta1_vec,theta2_vec,res_mat(:,:,1),theta1,theta2);

%% SA Plot %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
close all
% labels = {'Maximum Symptom Score','Time of Maximum Viral Titer','Area Under Viral Titer Curve','Duration of Infection','Fraction of Dead Cells'};
% labels1 = {'Max_S','Time_Max_V','AUC','Duration','Frac_Dead'};

labels = {'Maximum Symptom Score','Time of Max Symptom Score','Area Under Symptom Curve','Duration of Symptoms'};
labels1 = {'Max_S','Time_Max_S','AUC','Duration'};

xlab = {'Relative $\omega_2$','Relative $k$','Relative $r$'};
ylab = {'Relative $\eta$','Relative $f$','Relative $f$'};
    
for w = 1:4
figure
set(gca,'fontsize',16);
surf(theta1_vec/theta1,theta2_vec/theta2,res_mat(:,:,w));
if z == 1
xlabel('Relative $\omega$','Fontsize',26);
ylabel('Relative $\eta$','Fontsize',26);
elseif z == 2
xlabel('Relative $\omega$','Fontsize',26);
ylabel('Relative $\tilde{\eta}$','Fontsize',26);
end
title(labels(w),'Fontsize',26);
colormap jet
shading interp 
view(2)
cb=colorbar;
caxis([min(min((res_mat(:,:,w)))) max(max((res_mat(:,:,w))))])
cb.TickLabelInterpreter='latex';
set(gca, 'YScale', 'log')
set(gca, 'XScale', 'log')
if w == 1 || w == 3
set(gca,'ColorScale','log')
elseif w == 2 || w == 4
set(gca,'ColorScale','linear')
end
box on

filename = ['SD_SA_z',num2str(z),'_',char(labels1(w))];
if sav == 1
saveas(gcf,filename,'epsc')
savefig(gcf,filename)
end
shg

end


if sav == 1
filename = ['SD_SA_z',num2str(z)];
save(filename)
end
