%% Simulate the disease curves for different groups
%%% k3: 1e-5, mu3: 1e-1

g = 1;
N = 50;
sigma = 40;
t_end = 80;
inc = 2;
sc = [0.5,0.2];

figure
for i = 1:N

load('Par_1.mat')
[beta,p,delta,c,kappa,k1,k2,k3,k4,a1,a2,a3,a4,b1,b2,b3,w1,w2,w3,mu1,mu2,mu3,T0,V0] = Theta_func(Theta_s);

if g == 1
k3 = par_var(Theta_s(8),sc(1));
mu3 = par_var(Theta_s(22),sc(2));

elseif g == 2
k3 = par_var(5e-6,sc(1));
mu3 = par_var(5e-2,sc(2));
end
    
%% Vary Parameters %%%%%%%%%%%%%%%%%%

% k1 = par_var(k1,sc);
% k2 = par_var(k2,sc);
% k4 = par_var(k4,sc);
% mu1 = par_var(mu1,0.5*sc);
% mu2 = par_var(mu2,0.5*sc);
% beta = par_var(beta,0.25*sc);

% p = p;
% a1 = 100*a1;
% b1 = 100*b1;
% b3 = 10000*b3;
% a2 = a2;
% mu1 = 10*mu1;
% a4 = 1000*a4;
% a3 = 2;
% w1 = 0.01*w1;
% 
% % k1 = k1;
% % k2 = 1e-5;
% % k3 = k3;
% % k4 = 0.0005;
% 
% k1 = 0.5*k1;
% k2 = 0e-6;
% k3 = 0.5*k3;
% k4 = 0e-4;

% k3 = 1e-6;
% w1 = 50*w1;
% w2 = 0;
% w3 = 0;

%% Compute %%%%%%%%%%%%%%%%%%%%
ti = [0:inc:t_end];
Y0 = [T0,0,0,V0,0,0,0];

options = odeset('RelTol',1e-6,'AbsTol',1e-9);
[t,Y] = ode45(@(t,Y) Mod1(t,Y,beta,p,delta,c,kappa,k1,k2,k3,k4,a1,a2,a3,a4,b1,b2,b3,w1,w2,w3,mu1,mu2,mu3), ti, Y0, options);
lt = length(t);
noise_vec = sqrt(Y(:,7)).*normrnd(0,sigma,lt,1);
P = max(noise_vec + Y(:,7),0); 

%% Plot Everything  %%%%%%%%%%%%%%%%%%%%
% close all
% subplot(3,2,1)
% plot(t,Y(:,1),'linewidth',1);
% legend('$T$');
% 
% subplot(3,2,2)
% plot(t,Y(:,3),'linewidth',1);
% legend('$I$');
% 
% subplot(3,2,3)
% plot(t,Y(:,4),'linewidth',1);
% legend('$V$');
% 
% subplot(3,2,4)
% plot(t,Y(:,5),'linewidth',1);
% % semilogy(t,Y(:,5),'linewidth',1);
% legend('$M$')
% 
% subplot(3,2,5)
% plot(t,Y(:,6),'linewidth',1);
% % semilogy(t,Y(:,6),'linewidth',1);
% legend('$X$');
% 
% subplot(3,2,6)
% plot(t,Y(:,7),'linewidth',1);
% % semilogy(t,Y(:,7),'linewidth',1);
% legend('$P$');
% 
% % xlabel('Time (Days)','FontSize',22)
% % ylabel('$P$','FontSize',22)
% % legend('$V$','$M$','$X$','$P$');
% % Enlarge figure to full screen.
% set(gcf, 'Units', 'Normalized', 'OuterPosition', [0, 0.04, 0.8, 0.78]);
% shg
% 
% % max_I = max(Y(:,3))
% % max_V = max(Y(:,4))
% max_P = max(Y(:,7))
% % max_X = max(Y(:,6))
% 
% % Frac_Dead = 1 - min(Y(:,1))/T0

%% Plot P %%%%%%%%%%%%%%%%%%%%%
coll = {'b','r'};
titl = {'Group 1','Group 2'};
% coll = [1 0 0;
%         .5 0 .5];

hold on
box on
plot(t,P,'color',char(coll(g)),'linewidth',0.5);
% plot(t,Y(:,7),'color',coll(v,:),'linewidth',0.5);
xlabel(char(titl(g)))
axisfunc()

end
shg


