 %% Generate priors using training data
clear all
load('Synth_Dataset.mat')

tic
sav = 1;        % save?
z = 2;          % 1: Normal omega, eta; 2: rescaled
t_start = 0;    % Start time of sampling   
t_end = 10;     % End time of sampling   
inc = 0.5;      % Sampling interval
sigma1 = 0.278;    % Noise parameter

%%%%% MCMC Parameters %%%%%%%%%%
sd = 0.1*[1,1,1,1];
M = 5e2;         % Maximum theta vec
tstop = 300;      % Time of MCMC simulation
n = 32;           % Histogram refinement

for gr = 1:2
    
%%% Generate Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%    
if gr == 1
X1 = MCMC_prior([ti',dmatn_1],sigma1,sd,tstop,M,n,t_end);
elseif gr == 2
X2 = MCMC_prior([ti',dmatn_2],sigma1,sd,tstop,M,n,t_end);
end

end
toc


if sav == 1 
CL = clock;
filename = ['Prior_',date,'_',num2str(CL(4)),num2str(CL(5))];
save(filename)
end

%% Part 2

d_end = 3;
[X1a, X2a] = samelength(X1,X2);
M2 = 2e3;
tstop2 = 300;

X3 = MCMC_TS(test_dat_1,M2,1,sigma1,sd,tstop2,ones(4,1),[],[X1a;X2a],d_end,n);
plot_group_MCMC(X1,X2,X3)

%%% Plot Patch Figure
figure
patch_col = [0, 0, 1;
             1,0,0;
             0, 1, 0];  
legg = {'Healthy','Comorbid','New Patient'};
T = t_end;
A = [0.6,0.6,0.6];

for i = 1:3

if i == 1
theta_vec = X1;
elseif i == 2
theta_vec = X2;
elseif i == 3
theta_vec = X3;
end

if i == 3
T= d_end;
end
t = linspace(0,T);
Y_vec = MCMC_sim(theta_vec,t);
[me,yl,yu] = shade_func(Y_vec,95);
hold on
patch([t fliplr(t)], [yl fliplr(yu)],[1 0 0],'Facecolor',patch_col(i,:),'Facealpha',A(i)) 
end

scatter(test_dat1(:,1),test_dat1(:,2),50,'filled','k');
axisfunc()