%% Generate the dataset to be used in all forecasting figures in this study 


K = 24;           % Number of training patients
sav = 0;         % Save figures?
z = 2;           % 1: Normal omega, eta; 2: rescaled
t_start = 0;     % Start time of sampling   
t_end = 10;      % End time of sampling   
inc = 0.5;       % Sampling interval
sc = 0.3*ones(10,1);

sigma1 = 0.278;    % Training data noise (default = 0.7 for non-scaling, default = 0.278 for scaling)
% sigma1 = 0;    % Training data noise (default = 0.7 for non-scaling, default = 0.278 for scaling)
sigma3 = 0.278;   % MCMC likelihood function noise (default = 0.7 for non-scaling, default = 0.278 for scaling)
sigma4 = 0.2;
dis = 1;        % Display figures?
gen = 1;        % Generate data?


for gr = 1:2
    
%%% Generate Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
G = G_func(gr);     
if gr == 1
sc = 0.3*ones(10,1);
[dmat,dmatn_1,ti] = gen_data_SD(K,sc,G,sigma1,t_start,t_end,inc,z);
elseif gr == 2
sc = 0.3*ones(10,1);
[dmat,dmatn_2,ti] = gen_data_SD(K,sc,G,sigma1,t_start,t_end,inc,z);
end

%%% Generate Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
sc = eps*ones(10,1);
[dmat,dmatn,ti] = gen_data_SD(1,sc,G,sigma4,t_start,t_end,inc,z);
if gr == 1
test_dat_1 = [ti',dmatn];
elseif gr == 2
test_dat_2 = [ti',dmatn];
end

end

train_vec = [ti',dmatn_1,dmatn_2];

%% Plot
close all
hold on
p1 = plot(ti,dmatn_1,'color','b','linewidth',0.5);
p2 = plot(ti,dmatn_2,'color','r','linewidth',0.5);
p3 = scatter(test_dat_1(:,1),test_dat_1(:,2),50,'c','filled','MarkerEdgeColor','k');
p4 = scatter(test_dat_2(:,1),test_dat_2(:,2),50,'m','filled','MarkerEdgeColor','k');
axisfunc()
shg





