function [D,Dm] = plot_forecast_knn(train_vec,dat,Y_vec,d_end,dis)

[t1,d1,t2,d2] = split_data(dat,d_end);
t1 = t1'; d1 = d1'; t2 = t2'; d2 = d2';
t = dat(:,1);

%%% Compute Simulations and Forecast Error %%%%%%%%%%%%%%%%%%%%%%%%%%%%
Y_vec2 = Y_vec(:,[length(t1)+1:length(t)]);
S = size(train_vec,1);
D = zeros(S,1);
for i = 1:S
Y = Y_vec2(i,:);
D(i) = err_func(Y,d2);  
end

%%% Error of Mean Forecast %%%%%%%%%%%%%%%%%%%%%%%%%%%%
a = shade_func(Y_vec2,95);
Dm = err_func(a,d2);

if dis == 1
%%% Plot Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
hold on
p1 = plot(t,train_vec,'color',[0, 135, 0]/256,'linewidth',0.5);
axisfunc()

%%%% Plot Model Callibration %%%%%%%%%%%%%%%
me1 = shade_func(Y_vec,95);
me1 = me1([1:length(t1)]);
plot(t1,me1,'b--','linewidth',1.5);

%%%% Plot Model Forecast %%%%%%%%%%%%%%%
[me,yl,yu] = shade_func(Y_vec2,95);
a = length(t1);
if d_end ~= 0
me = [d1(a),me]; yl = [d1(a),yl]; yu = [d1(a),yu]; ta = [t1(a),t2];
else
ta = t2;    
end
alpha = 0.5;
patch([ta fliplr(ta)], [yl fliplr(yu)],[1 0 0],'Facecolor',[152, 188, 214]/256,'FaceAlpha',alpha)
p4 = plot(ta,me,'b','linewidth',1.5);

%%%% Plot Test Data %%%%%%%%%%%%%%%
p2 = scatter(t1,d1,50,'filled','k');
p3 = scatter(t2,d2,50,'filled','m');
xline(d_end,'k--','linewidth',1.5)
if d_end == 0
legend([p1(1),p3,p4],{'Training Data','Future Test Data','Forecast'},'FontSize',18);     
else
legend([p1(1),p2,p3,p4],{'Training Data','Observed Test Data','Future Test Data','Forecast'},'FontSize',18);    
end
shg
end

end