function [D,Dm] = plot_forecast_MCMC(theta_vec,train_vec,dat,Y_vec,d_end,dis,gr)

coll = {'b','r'};
patch_col = (1/256).*[152, 188, 214;
                      214,152,208];

%%% Compute Simulations and Forecast Error %%%%%%%%%%%%%%%%%%%%%%%%%%%%
S = size(theta_vec,1);
D = zeros(S,1);
[t1,d1,t2,d2] = split_data(dat,d_end);
t2a = linspace(t1(length(t1)),t2(length(t2)))';
if isempty(t1)
% t2a = t2;
st = 1;
else
% t2a = [t1(length(t1));t2];  
st = 2;
end
Y_vec2 = zeros(S,length(t2a));
t = dat(:,1);
for i = 1:S
theta = theta_vec(i,:);
Y0 = Q_func(t1,theta);
if isempty(t1)
Y = ode_func2(t2a,theta,[1,0]);    
else    
Y = ode_func2(t2a,theta,[Y0(1),d1(length(d1))]);
end
Y_vec2(i,:) = Y;
Y3 = interp1(t2a,Y,t2);
D(i) = err_func(Y3(st:length(Y3)),d2,4);
end

%%% Error of Mean Forecast %%%%%%%%%%%%%%%%%%%%%%%%%%%%
a = shade_func(Y_vec,95)';
b = interp1(t2a,Y,t2);
Dm = err_func(b(st:length(b)),d2,4);

if dis == 1
%%% Plot Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
hold on
% if ~isempty(train_vec)
% train_vec(:,1) = [];
% p1 = plot(t,train_vec,'color',[0, 135, 0]/256,'linewidth',0.5);
% end
axisfunc()

%%% Plot Model Calibration Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
t11 = linspace(0,t1(length(t1)));
Y_vec = MCMC_sim(theta_vec,t11);
me = shade_func(Y_vec,95);
% me = me([1:length(t1)]);
if gr == 1
plot(t11,me,'b--','linewidth',1.5);
elseif gr == 2
plot(t11,me,'r--','linewidth',1.5);
end

%%%% Plot Model Forecast %%%%%%%%%%%%%%%
[me,yl,yu] = shade_func(Y_vec2,95);
alpha = 0.5;
patch([t2a' fliplr(t2a')], [yl fliplr(yu)],[1 0 0],'Facecolor',patch_col(gr,:),'FaceAlpha',alpha)
p4 = plot(t2a,me,char(coll(gr)),'linewidth',1.5);

%%%% Plot Test Data %%%%%%%%%%%%%%%
p2 = scatter(t1,d1,50,'filled','k','MarkerEdgeColor','k');
% p3 = scatter(t2,d2,50,[0,0.6,0],'filled');
p3 = scatter(t2,d2,50,[255,130,0]./256,'filled','MarkerEdgeColor','k');
xline(d_end,'k--','linewidth',1.5)
if d_end == 0
legend([p1(1),p3,p4],{'Training Data','Future Test Data','Forecast'},'FontSize',20);     
else
if ~isempty(train_vec)    
% legend([p1(1),p2,p3,p4],{'Training Data','Observed Data','Future Data','Forecast'},'FontSize',20);    
legend([p2,p3,p4],{'Observed Data','Future Data','Forecast'},'FontSize',20);    
else
legend([p2,p3,p4],{'Observed Data','Future Data','Forecast'},'FontSize',20);    
end
end
shg
end

function Y = ode_func2(t,theta,Y0)
sol =  ode45(@(t,Y) TS(t,Y,theta(1),theta(2),theta(3)), t, Y0); 
Y1 = deval(sol,t)';
Y = Y1(:,2);
end

function Y0 = Q_func(t,theta)
if isempty(t)
Y0 = [1 1e-2];
else    
sol =  ode45(@(t,Y) TS(t,Y,theta(1),theta(2),theta(3)), t, [1, 1e-2]); 
Y1 = deval(sol,t)';
l = size(Y1,1);
Y0 = Y1(l,:);
end
end

end