function [dmat,dmatn,ti] = gen_data_SD(K,sc,G,sigma,t_start,t_end,inc,z)

load('Fritz99_Fit_6.mat')
load('Fritz99.mat')

[beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta,T0,~] = Theta_func_SD(Theta_s);
w20 = G(1)*w2;
if z == 1
eta0 = G(2)*eta;
elseif z == 2
eta_s0 = G(2)*eta/w2;
end
s10 = G(3)*s1;
k10 = G(4)*k1;
beta0 = beta;
p0 = p;
f0 = f;
r0 = r;
nu0 = nu;
mu0 = mu;

tf = [0:inc:t_end];
ti = [t_start:inc:t_end];
l = length(ti);
dmat = zeros(l,K);
dmatn = zeros(l,K);

%%% Generate Data %%%%%%%%%%%%%%%%%%%%%%%%%%%

for i = 1:K
w2 = mygamrnd(w20,(sc(1)*w20)^2);
% eta = mygamrnd(eta0,(sc(2)*eta0)^2);
if z == 1
eta = mygamrnd(eta0,(sc(2)*eta0)^2);
elseif z == 2
eta_s = mygamrnd(eta_s0,(sc(2)*eta_s0)^2);
eta = eta_s*w2;
end
s1 = mygamrnd(s10,(sc(3)*s10)^2);
k1 = mygamrnd(k10,(sc(4)*k10)^2);
beta = mygamrnd(beta0,(sc(5)*beta0)^2);
p = mygamrnd(p0,(sc(6)*p0)^2);
f = mygamrnd(f0,(sc(7)*f0)^2);
r = mygamrnd(r0,(sc(8)*r0)^2);
nu = mygamrnd(nu0,(sc(9)*nu0)^2);
mu = mygamrnd(mu0,(sc(10)*mu0)^2);


Y0 = [T0,0,0,1,0,0,0];
sol =  ode45(@(t,Y) SD(t,Y,beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta), tf, Y0);   
Y1 = deval(sol,ti)';
dmat(:,i) = Y1(:,7);  
end

%%% Add Noise %%%%%%%%%%%%%%%%%%%%%%%%%%%

for i = 1:K
Y2 = dmat(:,i);    
noise_vec = sqrt(Y2).*normrnd(0,sigma,l,1);
% noise_vec = normrnd(0,sigma,l,1);
dmatn(:,i) = max(noise_vec + Y2,0); 
end

end

%% Old %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% legend([p1 p2],{'Data',' Model'},'FontSize',18);


% gen = 1;            % Generate data?
% K = 48;             % Number of training data for each group
% g_test = 1;         % group to generate test data 
% t_end = 80;         % Length of simulation
% inc = 2;            % Time increment of observed data 
% sigma1 = 40;        % Training data noise (default = 40)
% sigma2 = 0;         % Testing data noise
% sigma3 = 40;        % MCMC likelihood function noise (default = 40)   
% sc = [1,0.2];       % SD of variable parameters
% 
% 
% %% Generate Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
% train_vec = zeros(K,t_end/inc+1,2);
% for g = 1:2
% for i = 1:K
% [k3,mu3] = par_vec_group(Theta_s,sc,g);
% P = gen_data(k3,mu3,Theta_s,sigma1,t_end,inc);
% train_vec(i,:,g) = P';
% end
% end
% 
% %% Generate Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
% sc = [eps,eps];
% [k3,mu3] = par_vec_group(Theta_s,sc,g_test);
% [P,t] = gen_data(k3,mu3,Theta_s,sigma2,t_end,inc);
% dat = [t,P];
% 
% %% Plot Training and Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
% figure 
% hold on
% % p1 = plot(t,train_vec(:,:,1),'b');
% % p2 = plot(t,train_vec(:,:,2),'r');
% for i = 1:K
% p1 = plot(t,train_vec(i,:,1),'b');
% p2 = plot(t,train_vec(i,:,2),'r');
% end
% p3 = scatter(t,dat(:,2),50,'filled','m');
% legend([p1(1),p2(1),p3],{'Group 1 Training Data','Group 2 Training Data','Test Data'},'FontSize',18); 
% ylim([0 2e5])
% axisfunc
