%% Fit Gamma Distribution to data

function [mu_p,sigma_p] = fit_gamma(theta_vec,disp)

l = size(theta_vec,2);
mu_p = zeros(l,1);
sigma_p = zeros(l,1);

for i = 1:l
A = theta_vec(:,i);
X = linspace(min(A),max(A));
p = gamfit(A);
mu_p(i) = p(1)*p(2);
sigma_p(i) = sqrt(p(1)*p(2)^2);
y = gampdf(X,p(1),p(2));
y1 = mygampdf(X,mu_p(i),sigma_p(i)^2);

if disp == 1
figure
h = histogram(A);
hold on
plot(X,max(h.Values)*y/max(y),'r','linewidth',1.5)
plot(X,max(h.Values)*y1/max(y1),'k--','linewidth',1.5)
shg
end

end

end
