
function [theta,Theta_s,Y,tf,err,res] = fit_func_SD(dat,u,Theta,dis,dis_data)

t1 = dat(:,1);
d1 = dat(:,2);
d2 = dat(:,3);
d3 = dat(:,4);
tf = linspace(0,t1(length(t1)));

[beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta,T0,V0] = Theta_func_SD(Theta);

beta_0 = beta;
p_0 = p;
s2_0 = s2;
k2_0 = k2;
nu_0 = nu;
mu_0 = mu;
w1_0 = w1;
w2_0 = w2;
eta_0 = eta;
k1_0 = k1;

tic


%% Fit SD Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 9 parameters: beta, p, s2, k2, nu, mu, w1, w2, eta

if u == 1
theta_0 = [beta_0, p_0, s2_0, k2_0, nu_0, mu_0, w1_0, w2_0, eta_0];
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',1e4,'MaxIter',1e4,'Display','off');
theta = fminsearch(@(theta) odefit_1(theta),theta_0,options);
theta = abs(theta);       
beta = theta(1);
p = theta(2);
s2 = theta(3);
k2 = theta(4);
nu = theta(5);
mu = theta(6);
w1 = theta(7);
w2 = theta(8);
eta = theta(9);
end

%% Fit SD Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 10 parameters: beta, p, s2, k2, nu, mu, w1, w2, eta, k1

if u == 2
theta_0 = [beta_0, p_0, s2_0, k2_0, nu_0, mu_0, w1_0, w2_0, eta_0, k1_0];
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',1e4,'MaxIter',1e4,'Display','off');
theta = fminsearch(@(theta) odefit_2(theta),theta_0,options);
theta = abs(theta);       
beta = theta(1);
p = theta(2);
s2 = theta(3);
k2 = theta(4);
nu = theta(5);
mu = theta(6);
w1 = theta(7);
w2 = theta(8);
eta = theta(9);
k1 = theta(10);
end

%% Fit SD Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 6 parameters: beta, p, nu, mu, w2, eta

if u == 3 
theta_0 = [beta_0, p_0, nu_0, mu_0, w2_0, eta_0];
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',1e4,'MaxIter',1e4,'Display','off');
theta = fminsearch(@(theta) odefit_3(theta),theta_0,options);
theta = abs(theta);       
beta = theta(1);
p = theta(2);
nu = theta(3);
mu = theta(4);
w2 = theta(5);
eta = theta(6);
end

%% Fit SD Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 5 parameters: beta, p, nu, mu,  k1

if u == 4 
theta_0 = [beta_0, p_0, nu_0, mu_0, k1_0];
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',1e4,'MaxIter',1e4,'Display','off');
theta = fminsearch(@(theta) odefit_4(theta),theta_0,options);
theta = abs(theta);       
beta = theta(1);
p = theta(2);
nu = theta(3);
mu = theta(4);
k1 = theta(5);
end

%% Fit SD Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 3 parameters: w1, w2, eta,

if u == 5 
theta_0 = [w1_0, w2_0, eta_0];
options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
% options = optimset('OutputFcn',@outfun,'MaxFunEvals',1e4,'MaxIter',1e4,'Display','off');
theta = fminsearch(@(theta) odefit_5(theta),theta_0,options);
theta = abs(theta);       
w1 = theta(1);
w2 = theta(2);
eta = theta(3);
end

%% Fit SD Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 2 parameters: beta, p
if u == 11
theta_0 = [beta_0, p_0];
options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
% options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_11(theta),theta_0,options);
theta = abs(theta);       
beta = theta(1);
p = theta(2);
end



%% Evaluate models at best-fit parameters %%%%%%%%%%%%%%%%%%%%%%%

Theta_s = [beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta,T0,d1(1)]';

err = fit_err_func(u);

sol = ode_func(tf);
Y = deval(sol,t1)';
Y1 = Y(:,4);  
Y2 = Y(:,7);  
Y3 = Y(:,6);  
% [~,res1] = Likelihood(d1,Y1,1,3); % Noise independent of amplitude
% [~,res2] = Likelihood(d2,Y2,1,1);
% [~,res3] = Likelihood(d3,Y3,1,1);
[~,res1] = Likelihood(d1,Y1,1,4);   % Noise scales with square root of amplitude
[~,res2] = Likelihood(d2,Y2,1,2);
[~,res3] = Likelihood(d3,Y3,1,2);
res = [res1,res2,res3];

Y = deval(sol,tf)';
Y1 = Y(:,4);  
Y2 = Y(:,7);  
Y3 = Y(:,6);  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Plot best-fit models
if dis == 1
    
figure(1)
p2 = semilogy(tf,Y1,'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d1,30,'markerfacecolor','b','markeredgecolor','k');
    box on 
    legend([p1 p2],{'Data',' Model'},'FontSize',18);
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)

figure(2)
p2 = plot(tf,Y2,'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d2,30,'markerfacecolor','b','markeredgecolor','k');
    box on 
    legend([p1 p2],{'Data',' Model'},'FontSize',18);
end
xlabel('Time (Days)','FontSize',22)
ylabel('Symptom Score','FontSize',22)


figure(3)
p2 = plot(tf,Y3,'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d3,30,'markerfacecolor','b','markeredgecolor','k');
    box on 
    legend([p1 p2],{'Data',' Model'},'FontSize',18);
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)


figure
p2 = semilogy(tf,Y(:,5),'r','Linewidth',1.5);
xlabel('Time (Days)','FontSize',22)
ylabel('Adaptive IR','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);

end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_1(theta)
    
theta = abs(theta);       
beta = theta(1);
p = theta(2);
s2 = theta(3);
k2 = theta(4);
nu = theta(5);
mu = theta(6);
w1 = theta(7);
w2 = theta(8);
eta = theta(9);
err = sum(fit_err_func(u));

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_2(theta)
    
theta = abs(theta);       
beta = theta(1);
p = theta(2);
s2 = theta(3);
k2 = theta(4);
nu = theta(5);
mu = theta(6);
w1 = theta(7);
w2 = theta(8);
eta = theta(9);
k1 = theta(10);
err = sum(fit_err_func(u));

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_3(theta)
    
theta = abs(theta);       
beta = theta(1);
p = theta(2);
nu = theta(3);
mu = theta(4);
w2 = theta(5);
eta = theta(6);
err = sum(fit_err_func(u));

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_4(theta)
    
theta = abs(theta);       
beta = theta(1);
p = theta(2);
nu = theta(3);
mu = theta(4);
k1 = theta(5);
err = sum(fit_err_func(u));

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_5(theta)
    
theta = abs(theta);       
w1 = theta(1);
w2 = theta(2);
eta = theta(3);
err = sum(fit_err_func(u));

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_11(theta)
    
theta = abs(theta);       
beta = theta(1);
p = theta(2);
err = sum(fit_err_func(u));

end


%% Error Function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function err = fit_err_func(u)

sol = ode_func(tf);    
Y = deval(sol,t1)';
Y1 = Y(:,4);  
Y2 = Y(:,7);  
Y3 = Y(:,6);  

if u == 1 || u == 2 || u == 3 
err1 = err_func(d1,Y1,3);
err2 = err_func(d2,Y2,2);
err3 = err_func(d3,Y3,2);
err = [err1,err2,err3];

elseif u == 4
err1 = err_func(d1,Y1,3);
err3 = err_func(d3,Y3,2);
err = [err1,err3];

elseif u == 5
err2 = err_func(d2,Y2,2);
err = err2;

elseif u == 11
err1 = err_func(d1,Y1,3);
err = err1;
end

end


%% Stop function if optimisation takes too long %%%%%%%%%%%%%%%%%%%%%%%%%%%
function stop = outfun(~,~,~)
stop = false;
ttoc = toc;
if ttoc > 120
    stop = true;
    disp('Max Time Exceeded')
else
end 
end

%% Function to evaluate model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sol = ode_func(t)

Y0 = [T0,0,0,d1(1),0,d3(1),d2(1)];
% Y0 = [T0,0,0,d1(1),0,0,0];
sol =  ode45(@(t,Y) SD(t,Y,beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta), t, Y0);   

end


end

