
function [theta,Y,t1,err,res] = fit_func(dat,u,dis,dis_data,t0)

t1 = dat(:,1);
d1 = dat(:,2);
inc = t1(2) - t1(1);

%% Fit Polynomial ODE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
if u == 1 || u == 2 || u == 3
if u == 1
theta_0 = [0.1,0.5];
elseif u == 2
theta_0 = [0.1,0.5,-0.3];
end

% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_1(theta),theta_0,options);
end


%% Fit QP Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit all 4 parameters

tic
if u == 4
theta_0 = [1e-3,1,0.1,1];
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_4(theta),theta_0,options);
end

%% Fit QP Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Don't fit initial condition

tic
if u == 5
theta_0 = [1e-3,1,0.1];
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_4(theta),theta_0,options);
end

%% Fit QP Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Use b3 as fitting parameter

tic
if u == 6
theta_0 = [1e-5,1,0.1,100];
options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
% options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_4(theta),theta_0,options);
end

%% Fit Special Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tic
if u == 7
theta_0 = [7,1,5,5e5];
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_7(theta),theta_0,options);
end

%% Fit TS Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit all 4 parameters

tic
if u == 8
theta_0 = [0.1,3,0.5,0.01];
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_8(theta),theta_0,options);
theta = abs(theta);
end

%% Fit TS Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 3 parameters

tic
if u == 9
theta_0 = [0.1,3,0.5];
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_8(theta),theta_0,options);
theta = abs(theta);
end

%% Fit TS Model and time %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 3 parameters and starting time t0

tic
if u == 10
theta_0 = [0.1,3,0.5,t0];
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_8(theta),theta_0,options);
theta = abs(theta);
end


%% Evaluate models at best-fit parameters %%%%%%%%%%%%%%%%%%%%%%%

err = fit_err_func(theta);



if u ~= 10
tt = t1;    
sol = ode_func(t1,theta,u);
if u == 1 || u == 2 || u == 3
Y = deval(sol,t1)';
else
Y1 = deval(sol,t1)';
Y = Y1(:,2);
[~,res,~] = Likelihood(d1,Y,1,2);
end
elseif u == 10
t2 = linspace(0,t1(length(t1))+theta(4));
sol =  ode45(@(t,Y) TS(t,Y,theta(1),theta(2),theta(3)), t2, [1, 1e-2]); 
Y1 = deval(sol,t2)';
Y = Y1(:,2); 
tt = t2 - theta(4);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Plot best-fit models
if dis == 1
p2 = plot(tt,Y,'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d1,30,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Symptom Score','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_1(theta)
err = fit_err_func(theta);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_4(theta)
err = fit_err_func(theta);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_7(theta)
err = fit_err_func(theta);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_8(theta)
err = fit_err_func(theta);
end



%% Error Function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function err = fit_err_func(theta)
theta = abs(theta);
    
if u ~= 10
sol = ode_func(t1,theta,u);
ts = sol.x;
l = length(ts);

if ts(l) == t1(length(t1))
if u == 1 || u == 2 || u == 3
Y = deval(sol,t1)';
elseif u == 4 || u == 5 || u == 6 || u == 8 || u == 9
Y1 = deval(sol,t1)'; 
Y = Y1(:,2);  
end
% err = err_func(d1,Y,1); % non scaling noise
err = err_func(d1,Y,2); % scaling noise
else 
err = 1e50;
end

% elseif u == 7
% Y = special(t1,theta(1),theta(2),theta(3),theta(4));  
% err = err_func(d1,Y,1)

elseif u == 10

t2 = linspace(0,50);
sol =  ode45(@(t,Y) TS(t,Y,theta(1),theta(2),theta(3)), t2, [1, 1e-2]); 
tt = [theta(4):inc:theta(4)+t1(length(t1))];
Y1 = deval(sol,tt)';
Y = Y1(:,2); 
err = err_func(d1,Y,1);
end
    
end


%% Stop function if optimisation takes too long %%%%%%%%%%%%%%%%%%%%%%%%%%%
function stop = outfun(~,~,~)
stop = false;
ttoc = toc;
if ttoc > 20
    stop = true;
    disp('Max Time Exceeded')
else
end 
end

%% Function to evaluate model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sol = ode_func(t,theta,u)
    
theta = abs(theta);
    
if u == 1
sol =  ode45(@(t,Y) theta(1) + theta(2)*Y, t, 0); 
elseif u == 2
sol =  ode45(@(t,Y) theta(1) + theta(2)*Y + theta(3)*Y^2, t, 0); 
elseif u == 3
sol =  ode45(@(t,Y) theta(1) + theta(2)*Y + theta(3)*Y^2 + theta(4)*Y^3, t, 0); 

elseif u == 4
sol =  ode45(@(t,Y) QP(t,Y,theta(1),theta(2),theta(3),0), t, [1, theta(4)]); 

elseif u == 5
sol =  ode45(@(t,Y) QP(t,Y,theta(1),theta(2),theta(3),0), t, [1, 1]); 

elseif u == 6
sol =  ode45(@(t,Y) QP(t,Y,theta(1),theta(2),theta(3),theta(4)), t, [1, 0]); 

elseif u == 8
sol =  ode45(@(t,Y) TS(t,Y,theta(1),theta(2),theta(3)), t, [1, theta(4)]); 

elseif u == 9
sol =  ode45(@(t,Y) TS(t,Y,theta(1),theta(2),theta(3)), t, [1, 1e-2]); 
% sol =  ode45(@(t,Y) TS(t,Y,theta(1),theta(2),theta(3)), t, [1, d1(1)]); 

end    

end


end

