function [theta_vec,acc_vec,guess,MLE] = MCMC_TS(dat,M,z,sigma,sd,tstop,mu_p,sigma_p,prior_vec,d_end,n)

if ~isempty(dat)
if isempty(d_end)
t = dat(:,1);
d1 = dat(:,2);    
else    
[t,d1] = split_data(dat,d_end);
end
guess = fit_func(dat,9,0,0); %% MLE

else
guess = mu_p;
end

%% Initialise 
tstart = tic;
r_old = -eps;
co = 1;
theta_vec = zeros(1,length(guess));
acc_vec = zeros(1,2);

%% Run Algorithm
while co <= M
if toc(tstart) < tstop
theta = get_par(co,theta_vec);  % get parameters from proposal
L = like_func(theta);           % calculate likelihood
pr = calc_prob(theta,L,mu_p,sigma_p);  % calculate probability

%%%%% Accept/Reject %%%%%%%%%%%%%%%%%%%%%%%%%%
if pr > r_old
   disp_iter(co,500)                % display iteration   
   theta_vec(co,:) = theta; 
   acc_vec(co,:) = [L,pr];
   co = co+1;
   r_old = pr; 
else 
    a = rand;
        if a < pr/r_old
        disp_iter(co,500)                % display iteration     
        theta_vec(co,:) = theta; 
        acc_vec(co,:) = [L,pr];
        co = co+1;
        r_old = pr; 
       end
end 
else
    break
end
end

MLE = MLE_func(theta_vec,acc_vec);

%% Display Iteration 
function disp_iter(i,A)
    
if floor(i/A) == i/A
        disp(i)
end

end

%% Get Parameters %%%%%%%%%%%%%%%%%%%%%
function [theta] = get_par(co,theta_vec)

l = size(theta_vec,2); 
if co == 1        
    theta = guess;
else            
    for j = 1:l
    theta_log(j) = normrnd(log10(theta_vec(co-1,j)),sd(j));
    end
    theta = 10.^theta_log; 
end  

end

%% Likelihood Function %%%%%%%%%%%%%%%%%%%%%
function L = like_func(theta)       

if ~isempty(dat)
sol =  ode45(@(t,Y) TS(t,Y,theta(1),theta(2),theta(3)), t, [1, 1e-2]); 
if max(t) <= max(sol.x)
Y1 = deval(sol,t)';
Y = Y1(:,2);
[~,~,L] = Likelihood(d1,Y,sigma,2);
else 
L = 0;
end
else 
L = 1;
end

end

%% Remove Burn in Period %%%%%%%%%%%%%%%%%%%%%
function [theta_vec] = burn(theta_vec,bn)
h = floor(length(beta_vec)*bn);
theta_vec([1:h],:) = [];
end

%% Thin Samples %%%%%%%%%%%%%%%%%%%%%
function [theta_vec_c] = thin_func(theta_vec,z)
lb = size(theta_vec,1);    
d = floor(lb/z)-1;
theta_vec_c = zeros(d,size(theta_vec,2));
for j = 1:d
    theta_vec_c(j,:) = theta_vec(z*j,:);
end
end

%% Calculate MLE %%%%%%%%%%%%%%%%%%%%%
function MLE = MLE_func(theta_vec,acc_vec)
[~,I] = max(acc_vec(:,1)); 
MLE = theta_vec(I,:);
end

%% Calculate Probabilities Using Priors %%%%%%%%%%%%%%%%%%%%%
function pr = calc_prob(theta,L,mu_p,sigma_p)

if isempty(prior_vec)    
l = length(theta);
Q = zeros(l,1);    
for j = 1:l
    if isempty(sigma_p)    
    if theta(j) >= 0    
%     disp('Q=1')
    Q(j) = 1;
    else
    Q(j) = 0;
    end   
    else       
    Q(j) = mygampdf(theta(j),mu_p(j),(sigma_p(j))^2);
%     disp('mygam')
    end
end
pr = L*prod(Q);

else
pr = L*prior(theta,prior_vec,n); 
end

end

end
