function [theta_vec,acc_vec] = MCMC_SD(dat,M,tstop,guess,Theta,sigma,sd)

t1 = dat(:,1);
d1 = dat(:,2);
d2 = dat(:,3);
d3 = dat(:,4);
tf = linspace(0,t1(length(t1)));
[beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta,T0,~] = Theta_func_SD(Theta);


%% Initialise 
tstart = tic;
r_old = -eps;
co = 1;
theta_vec = zeros(1,length(guess));
acc_vec = zeros(1,2);

%% Run Algorithm
while co <= M
if toc(tstart) < tstop
theta = get_par(co,theta_vec);  % get parameters from proposal
L = like_func(theta);           % calculate likelihood
pr = calc_prob(theta,L);  % calculate probability

%%%%% Accept/Reject %%%%%%%%%%%%%%%%%%%%%%%%%%
if pr > r_old
   disp_iter(co,500)                % display iteration   
   theta_vec(co,:) = theta; 
   acc_vec(co,:) = [L,pr];
   co = co+1;
   r_old = pr; 
else 
    a = rand;
        if a < pr/r_old
        disp_iter(co,500)                % display iteration     
        theta_vec(co,:) = theta; 
        acc_vec(co,:) = [L,pr];
        co = co+1;
        r_old = pr; 
       end
end 
else
    break
end
end

% MLE = MLE_func(theta_vec,acc_vec);

%% Display Iteration 
function disp_iter(i,A)
    
if floor(i/A) == i/A
        disp(i)
end

end

%% Get Parameters %%%%%%%%%%%%%%%%%%%%%
function [theta] = get_par(co,theta_vec)

l = size(theta_vec,2); 
if co == 1        
    theta = guess;
else            
    for j = 1:l
    theta_log(j) = normrnd(log10(theta_vec(co-1,j)),sd(j));
    end
    theta = 10.^theta_log; 
end  

end

%% Likelihood Function %%%%%%%%%%%%%%%%%%%%%
function L = like_func(theta)       

Y0 = [T0,0,0,d1(1),0,d3(1),d2(1)];
theta = abs(theta);       
beta = theta(1);
p = theta(2);
nu = theta(3);
mu = theta(4);
w2 = theta(5);
eta = theta(6);
sol =  ode45(@(t,Y) SD(t,Y,beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta), tf, Y0);   
if max(tf) <= max(sol.x)
Y = deval(sol,t1)';
Y1 = Y(:,4);  
Y2 = Y(:,7);  
Y3 = Y(:,6); 
[~,~,L1] = Likelihood(d1,Y1,sigma(1),3);
[~,~,L2] = Likelihood(d2,Y2,sigma(2),1);
[~,~,L3] = Likelihood(d3,Y3,sigma(3),1);
L = L1*L2*L3;
else 
L = 0;
end

end


%% Calculate Probabilities Using Priors %%%%%%%%%%%%%%%%%%%%%
function pr = calc_prob(theta,L)

if theta >= zeros(length(theta),1)
    pr = L;
else 
    pr = 0;
end

end

% %% Remove Burn in Period %%%%%%%%%%%%%%%%%%%%%
% function [theta_vec] = burn(theta_vec,bn)
% h = floor(length(beta_vec)*bn);
% theta_vec([1:h],:) = [];
% end
% 
% %% Thin Samples %%%%%%%%%%%%%%%%%%%%%
% function [theta_vec_c] = thin_func(theta_vec,z)
% lb = size(theta_vec,1);    
% d = floor(lb/z)-1;
% theta_vec_c = zeros(d,size(theta_vec,2));
% for j = 1:d
%     theta_vec_c(j,:) = theta_vec(z*j,:);
% end
% end
% 
% %% Calculate MLE %%%%%%%%%%%%%%%%%%%%%
% function MLE = MLE_func(theta_vec,acc_vec)
% [~,I] = max(acc_vec(:,1)); 
% MLE = theta_vec(I,:);
% end

end
