%% Make a forecast
clear 
tstart1 = tic;
load('Par_1.mat')
sav = 0;       % Save figures?
% load('Data_sigma_40.mat')
% load('Data_sigma_10.mat')

%% Forecast Parameters %%%%%%%%%%
gen = 1;       % Generate data?
d_end = 0;     % Forecast made at this time
K = 1;         % Number of training data
t_end = 80;     % Length of simulation
inc = 2;        % Time increment of observed data 
sigma1 = 40;    % Training data noise (default = 40)
sigma2 = 0;     % Testing data noise
sigma3 = 10;    % MCMC likelihood function noise (default = 40)   
sc = [1,0.2];   % SD of variable parameters
dis = 1;        % Display figures?

%%%%% MCMC Parameter %%%%%%%%%%
M = 1e3;        % Maximum theta vec
tstop1 = 30;    % Time of each prior simulation 
tstop2 = 30;    % Time of forecasting simulation 
n = 32;         % Histogram refinement

%%%%% knn Parameters %%%%%%%%%%
m = 1;      % kNN weighting parameter
N = 1e3;    % Number of output simulations

%% Generate Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
if gen == 1
if K ~= 0
train_vec = zeros(K,t_end/inc+1);
for i = 1:K
k3 = par_var(Theta_s(8),1);
mu3 = par_var(Theta_s(22),0.2);
P = gen_data(k3,mu3,Theta_s,sigma1,t_end,inc);
train_vec(i,:) = P';
end
end
end

%% Generate Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
if gen == 1
k3 = par_var(Theta_s(8),sc(1));
mu3 = par_var(Theta_s(22),sc(2));
k3 = par_var(Theta_s(8),eps);
mu3 = par_var(Theta_s(22),eps);
[P,t] = gen_data(k3,mu3,Theta_s,sigma2,t_end,inc);
dat = [t,P];
end

%% k-NN Forecast
if v == 1
Y_vec = knn(dat,train_vec,t,d_end,m,N);
figure
[D,Dm] = plot_forecast_knn(train_vec,dat,Y_vec,d_end,dis);


%% MCMC Forecast %%%%%%%%%%%%%%%%%%%
%%%%% Compute Prior %%%%%%%%%%%
elseif v == 2
sd = 0.1*[1,1,1,1];
t = [0:inc:t_end]';
tstart = tic;
if K ~= 0
prior_vec = MCMC_prior(train_vec,t,sigma1,sd,tstop1,M,n);
else
prior_vec = [];    
train_vec = [];
end

%%%%% Compute Forecast %%%%%%%%%%%
if d_end ~= 0
[theta_vec,acc_vec,guess,MLE] = MCMC_QP(dat,1e10,1,sigma3,sd,tstop2,ones(4,1),[],prior_vec,d_end,n);
else
theta_vec = prior_vec;
end
Y_vec = MCMC_sim(theta_vec,t);
figure
[D,Dm] = plot_forecast_MCMC(theta_vec,train_vec,dat,Y_vec,d_end,dis);
end

%% Save Figures
if sav == 1
CL = clock;
filename = ['Forecast_v',num2str(v),'_sigma',num2str(sigma),'_K',num2str(K),'_d',num2str(d_end),'_',date,'_',num2str(CL(4)),num2str(CL(5))];
saveas(gcf,filename,'epsc')
savefig(gcf,filename)
end

toc(tstart1)

