%% Make a forecast using the TS model
clear all
load('Synth_Dataset.mat')
load_prior = 0;

if load_prior == 1
load('Prior_25-Feb-2021_1557.mat')
[X1a, X2a] = samelength(X1,X2);
end

d_end_vec = [2,3,4];
ld = length(d_end_vec);
K = 0;           % Number of training patients
sav = 1;         % Save figures?
z = 2;           % 1: Normal omega, eta; 2: rescaled
t_start = 0;     % Start time of sampling   
t_end = 10;      % End time of sampling   
inc = 0.5;       % Sampling interval
sc = 0.3*ones(10,1);
% sc = 0.3*ones(10,1);
% sc = eps*ones(10,1);

sigma1 = 0.278;    % Training data noise (default = 0.7 for non-scaling, default = 0.278 for scaling)
sigma3 = 0.278;   % MCMC likelihood function noise (default = 0.7 for non-scaling, default = 0.278 for scaling)
dis = 1;        % Display figures?
gen = 0;        % Generate data?

%%%%% MCMC Parameters %%%%%%%%%%
sd = 0.1*[1,1,1,1];
M1 = 1e3;         % Maximum theta vec
M2 = 1e3;         % Maximum theta vec
tstop1 = 60;    % Time of MCMC simulation
tstop2 = 60;    % Time of MCMC simulation
n = 32;          % Histogram refinement

tstart0 = tic;
for gr = 1:2
G = G_func(gr);    
    
for i = 1:ld
d_end = d_end_vec(i);    
    
% d_end = 4;       % Forecast made at this time
% gr = 2;          % group

%%% Generate Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
if gen == 1
if K ~= 0
[dmat,dmatn,ti] = gen_data_SD(K,sc,G,sigma1,t_start,t_end,inc,z);
train_vec = [ti',dmatn];
end
end

%%% Generate Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
if gen == 1
sc = eps*ones(10,1);
[dmat,dmatn,ti] = gen_data_SD(1,sc,G,sigma1,t_start,t_end,inc,z);
test_dat = [ti',dmat];
end

%%%%%% MCMC Forecast %%%%%%%%%%%%%%%%%%%
%%% Compute Prior %%%%%%%%%%%
t = [0:inc:t_end]';
tstart = tic;
if K ~= 0
prior_vec = MCMC_prior(train_vec,sigma1,sd,tstop1,M1,n,t_end);
else
if load_prior ~= 1
prior_vec = [];    
train_vec = [];
end
end


%% Compute Forecast %%%%%%%%%%%
if d_end ~= 0
if load_prior == 1    
prior_vec = [X1a;X2a];
end
[theta_vec,acc_vec,guess,MLE] = MCMC_TS(test_dat_func(gr,test_dat_1,test_dat_2),M2,1,sigma3,sd,tstop2,ones(3,1),[],prior_vec,d_end,n);
else
theta_vec = prior_vec;
end

%% Plot Forecast %%%%%%%%%%%%%%%
Y_vec = MCMC_sim(theta_vec,t);
figure
[D,Dm] = plot_forecast_MCMC(theta_vec,train_vec,test_dat_func(gr,test_dat_1,test_dat_2),Y_vec,d_end,dis,gr);
ylim([0 20])
DIC2(gr,i) = mean(D) + 0.5*var(D);

%% Save Figures
if sav == 1 
CL = clock;
filename = ['Forecast_K',num2str(K),'gr',num2str(gr),'_d',num2str(d_end),'_',date,'_',num2str(CL(4)),num2str(CL(5))];
saveas(gcf,filename,'epsc')
savefig(gcf,filename)
end
end
end
toc(tstart0)

if sav == 1 
filename = ['Forecast_K',num2str(K),'_',date,'_',num2str(CL(4)),num2str(CL(5))];
save(filename)
end



