%% Make a forecast using MCMC or KNN and compare accuracy as K is varied
close all
clear all
load('Par_1.mat')
sav = 1;

%% Forecast Parameters %%%%%%%%%%
K_vec = [2:2:30];
R = 10;         % Number of repeat experiments
d_end = 10;      % Forecast made at this time
t_end = 80;     % Length of simulation
inc = 2;        % Time increment of observed data 
sigma1 = 40;    % Training data noise (Default 40)
sigma2 = 0;     % Testing data noise
sc = [1,0.2];   % SD of variable parameters
dis = 0;        % Display figures?

%%%%% MCMC Parameter %%%%%%%%%%
tstop1 = 5;    % Time of each prior simulation
tstop2 = 5;     % Time of forecasting simulation
n = 32;         % Histogram refinement

%%%%% knn Parameters %%%%%%%%%%
m = 1;      % kNN weighting parameter
N = 1e3;    % Number of output simulations

lK = length(K_vec);
forecast_err_DIC = zeros(lK,R,2);
forecast_err_SSR = zeros(lK,R,2);

tstart1 = tic;
for r = 1:R
r    
for j = 1:lK
K = K_vec(j);
K;
for v = 1:2
v;    

%% Generate Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
if v == 1
if K ~= 0
train_vec = zeros(K,t_end/inc+1);
for i = 1:K
k3 = par_var(Theta_s(8),1);
mu3 = par_var(Theta_s(22),0.2);
P = gen_data(k3,mu3,Theta_s,sigma1,t_end,inc);
train_vec(i,:) = P';
end
end
end

%% Generate Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
if j == 1 && v == 1
k3 = par_var(Theta_s(8),eps);
mu3 = par_var(Theta_s(22),eps);
[P,t] = gen_data(k3,mu3,Theta_s,sigma2,t_end,inc);
dat = [t,P];
end

%% k-NN Forecast
if v == 1
Y_vec = knn(dat,train_vec,t,d_end,m,N);
[D,Dm] = plot_forecast_knn(train_vec,dat,Y_vec,d_end,dis);

%% MCMC Forecast %%%%%%%%%%%%%%%%%%%
elseif v == 2
M = 500;
sd = 0.1*[1,1,1,1];
t = [0:inc:t_end]';
if K ~= 0
prior_vec = MCMC_prior(train_vec,t,sigma1,sd,tstop1,M,n);
else
prior_vec = [];    
train_vec = [];
end
if d_end ~= 0
[theta_vec,acc_vec,guess,MLE] = MCMC_QP(dat,1e10,1,sigma1,sd,tstop2,ones(4,1),[],prior_vec,d_end,n);
else
theta_vec = prior_vec;
end
Y_vec = MCMC_sim(theta_vec,t);
[D,Dm] = plot_forecast_MCMC(theta_vec,train_vec,dat,Y_vec,d_end,dis);
end

forecast_err_DIC(j,r,v) = mean(D) + 0.5*var(D);
forecast_err_SSR(j,r,v) = Dm;

end
end
end
toc(tstart1)

if sav == 1
aa = clock;
filename = ['F_Accuracy_K_R',num2str(R),'_sigma',num2str(sigma1),'_d',num2str(d_end),'_',date,'_',num2str(aa(4)),num2str(aa(5))];
save(filename)
end

%%
sav = 1;
% Uncomment to rename variables and edit 
% forecast_err_DIC_QP = forecast_err_DIC(:,:,2);
% forecast_err_DIC_knn = forecast_err_DIC(:,:,1);
% forecast_err_SSR_QP = forecast_err_SSR(:,:,2);
% forecast_err_SSR_knn = forecast_err_SSR(:,:,1);

figure
hold on
plot(K_vec,mean(forecast_err_DIC_QP,2),'Color',[0.4940, 0.1840, 0.5560],'linewidth',1.5)
plot(K_vec,mean(forecast_err_DIC_knn,2),'Color',[0.3010, 0.7450, 0.9330],'linewidth',1.5)
xlabel('Number of Datasets','FontSize',22)
ylabel('Forecast Error (DIC)','FontSize',22)
title(['Forecast at Day ',num2str(d_end)],'FontSize',22)
legend('QP Model','KNN','FontSize',18)
box on
% set(gca, 'YScale', 'log')
ylim([0 12e16])
shg
if sav == 1
filename = ['F_Accuracy_DIC_K_R',num2str(R),'_sigma',num2str(sigma1),'_d',num2str(d_end)];
saveas(gca,['F_Accuracy_DIC_K_R',num2str(R),'_sigma',num2str(sigma1),'_d',num2str(d_end),'.fig']);
print(gcf,filename,'-depsc')
end

figure
hold on
plot(K_vec,mean(forecast_err_SSR_QP,2),'Color',[0.4940, 0.1840, 0.5560],'linewidth',1.5)
plot(K_vec,mean(forecast_err_SSR_knn,2),'Color',[0.3010, 0.7450, 0.9330],'linewidth',1.5)
xlabel('Number of Datasets','FontSize',22)
ylabel('Forecast Error (Mean)','FontSize',22)
title(['Forecast at Day ',num2str(d_end)],'FontSize',22)
legend('QP Model','KNN','FontSize',18)
box on
% set(gca, 'YScale', 'log')
ylim([0 20e7])
shg
if sav == 1
filename = ['F_Accuracy_SSR_K_R',num2str(R),'_sigma',num2str(sigma1),'_d',num2str(d_end)];
saveas(gca,['F_Accuracy_SSR_K_R',num2str(R),'_sigma',num2str(sigma1),'_d',num2str(d_end),'.fig']);
print(gcf,filename,'-depsc')
end

