 %% Generate synthetic symptom score data from the SD model

close all
z = 2;           % 1: Normal omega, eta; 2: rescaled
K = 50;        % Number of patients
gr = 1;         % group
t_start = 0;    % Start time of sampling   
t_end = 10;     % End time of sampling   
inc = 0.1;      % Sampling interval
sigma = 0.3;    % Noise parameter
sc = 0.3*ones(10,1);
% sc(1) = 0.3;  % w2
% sc(2) = 0.3;  % eta
% sc = eps*ones(10,1);

figure
for gr = [2,1]
    
G = G_func(gr)

[dmat,dmatn,ti] = gen_data_SD(K,sc,G,sigma,t_start,t_end,inc,z);


%% Plot Data

hold on
if gr == 1
p1 = plot(ti,dmat,'b','Linewidth',1);
elseif gr == 2
p2 = plot(ti,dmat,'r','Linewidth',1);
end
xlabel('Time (Days)','FontSize',22)
ylabel('Symptom Score','FontSize',22)
box on 
shg

end

legend([p1(1),p2(1)],{'Healthy','Comorbid'},'FontSize',18); 


% figure
% hold on
% plot(tf,dmatn,'Linewidth',1.5);
% xlabel('Time (Days)','FontSize',22)
% ylabel('Symptom Score','FontSize',22)
% box on 
% shg

%% Plot Distributions %%%%%%%%%%%%%%%%%%%%%%%%%%
% x = linspace(0,3);
% y = mygampdf(x,w20,(sc*w20)^2);
% plot(x,y)
% 
% x = linspace(0,60);
% y = mygampdf(x,eta0,(sc*eta0)^2);
% figure
% plot(x,y)
% shg


%% Old %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% legend([p1 p2],{'Data',' Model'},'FontSize',18);


% gen = 1;            % Generate data?
% K = 48;             % Number of training data for each group
% g_test = 1;         % group to generate test data 
% t_end = 80;         % Length of simulation
% inc = 2;            % Time increment of observed data 
% sigma1 = 40;        % Training data noise (default = 40)
% sigma2 = 0;         % Testing data noise
% sigma3 = 40;        % MCMC likelihood function noise (default = 40)   
% sc = [1,0.2];       % SD of variable parameters
% 
% 
% %% Generate Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
% train_vec = zeros(K,t_end/inc+1,2);
% for g = 1:2
% for i = 1:K
% [k3,mu3] = par_vec_group(Theta_s,sc,g);
% P = gen_data(k3,mu3,Theta_s,sigma1,t_end,inc);
% train_vec(i,:,g) = P';
% end
% end
% 
% %% Generate Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
% sc = [eps,eps];
% [k3,mu3] = par_vec_group(Theta_s,sc,g_test);
% [P,t] = gen_data(k3,mu3,Theta_s,sigma2,t_end,inc);
% dat = [t,P];
% 
% %% Plot Training and Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
% figure 
% hold on
% % p1 = plot(t,train_vec(:,:,1),'b');
% % p2 = plot(t,train_vec(:,:,2),'r');
% for i = 1:K
% p1 = plot(t,train_vec(i,:,1),'b');
% p2 = plot(t,train_vec(i,:,2),'r');
% end
% p3 = scatter(t,dat(:,2),50,'filled','m');
% legend([p1(1),p2(1),p3],{'Group 1 Training Data','Group 2 Training Data','Test Data'},'FontSize',18); 
% ylim([0 2e5])
% axisfunc
