%% Generate synthetic data and fit phenomenological model to data 

clear all
close all
gr = 1;         % group
K = 1;        % Number of patients
t_start = 3;    % Start time of sampling   
t_end = 10;     % End time of sampling   
inc = 0.5;      % Sampling interval
% sigma = 0.3;    % Noise parameter
sigma = 0;    % Noise parameter
z = 2;           % 1: Normal omega, eta; 2: rescaled
sc = 0.3*ones(10,1);
% sc = eps*ones(10,1);
G = G_func(gr);

% [dmat,dmatn,ti] = gen_data_SD(K,sc,G,sigma,t_start,t_end,inc,z);
% ti = ti-t_start;
% dat = [ti',dmatn];

load('Synth_Dataset_Min.mat')
x = t_start/inc;
dat1 = test_dat_func(gr,test_dat_1,test_dat_2);
dat1(:,1) = ti'-t_start;
dat = dat1;
dat1([x+1:length(dat1)],:) = [];
dat([1:x],:) = [];
ti([1:x]) = [];
dat(:,1) = ti'-t_start;


%%%% Call TS Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
u = 10;
dis = 1;
dis_data = 1;
[theta,Y,t,err] = fit_func(dat,u,dis,dis_data,t0);
xlim([-theta(4) inf])
xline(0,'k--','linewidth',1.5)
t0 = theta(4);


% t = linspace(0,t_end);
% sol =  ode45(@(t,Y) TS(t,Y,a1,a2,a3), t, [1, S0]); 
% Y1 = deval(sol,t)';
% S = Y1(:,2);
% 
% figure 
% hold on
% p1 = scatter(dat(:,1),dat(:,2),30,'markerfacecolor','b','markeredgecolor','k');
% p2 = plot(t,S,'r','Linewidth',1.5);
% xlabel('Time (Days)','FontSize',22)
% ylabel('Symptom Score','FontSize',22)
% box on
% legend([p1 p2],{'Data','TS Model'},'FontSize',18);


