%% Generate synthetic data and fit phenomenological model to data 

clear all
hold on
K = 1;       % Number of patients
t_start = 2;     % Start time of sampling   
t_end = 15;     % End time of sampling   
inc = 0.5;      % Sampling interval
sigma = 0.3;    % Noise parameter

sc1 = 0.2;  % w2
sc2 = 0.2;  % eta
sc3 = 0.5;  % beta
sc4 = 0.5;  % s1
sc5 = 0.5;  % k
sc6 = 0.5;  % mu
sc7 = 0.5;  % p
sc = [sc1,sc2,sc3,sc4,sc5,sc6,sc7];
sc = 0.3*ones(10,1);
z = 1;
gr = 1;
G = G_func(gr);
% sc = eps*ones(7,1);

[dmat,dmatn,ti] = gen_data_SD(K,sc,G,sigma,t_start,t_end,inc,z);
ti = ti-t_start;
dat = [ti',dmat];

%%%% Call TS Model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
a1 = 0.1;
a2 = 3;
a3 = 0.5;
S0 = 0.01;

% t = linspace(0,t_end);
% sol =  ode45(@(t,Y) TS(t,Y,a1,a2,a3), t, [1, S0]); 
% Y1 = deval(sol,t)';
% S = Y1(:,2);
% 
% figure 
% hold on
% p1 = scatter(dat(:,1),dat(:,2),30,'markerfacecolor','b','markeredgecolor','k');
% p2 = plot(t,S,'r','Linewidth',1.5);
% xlabel('Time (Days)','FontSize',22)
% ylabel('Symptom Score','FontSize',22)
% box on
% legend([p1 p2],{'Data','TS Model'},'FontSize',18);

u = 10;
dis = 1;
dis_data = 1;
% close all
[theta,Y,t,err] = fit_func(dat,u,dis,dis_data);
xlim([-theta(4) inf])
xline(0,'k--','linewidth',1.5)
t0 = theta(4)
shg


